/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.throttling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.throttling.ThrottleResponse;
import org.apache.cxf.throttling.ThrottlingCounter;

public class ThrottlingResponseInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ThrottlingResponseInterceptor() {
        super("setup");
    }

    public void handleMessage(Message message) throws Fault {
        ThrottlingCounter tCounter;
        ThrottleResponse rsp = (ThrottleResponse)message.getExchange().get(ThrottleResponse.class);
        if (rsp != null) {
            TreeMap<String, List<String>> headers;
            if (rsp.getResponseCode() > 0) {
                message.put((Object)Message.RESPONSE_CODE, (Object)rsp.getResponseCode());
                if (rsp.getErrorMessage() != null) {
                    message.put((Object)Message.ERROR_MESSAGE, (Object)rsp.getErrorMessage());
                }
            }
            if ((headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)))) == null) {
                headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                message.put((Object)Message.PROTOCOL_HEADERS, headers);
            }
            for (Map.Entry<String, String> e : rsp.getResponseHeaders().entrySet()) {
                ArrayList<String> r = (ArrayList<String>)headers.get(e.getKey());
                if (r == null) {
                    r = new ArrayList<String>();
                    headers.put(e.getKey(), r);
                }
                r.add(e.getValue());
            }
            if (rsp.getResponseCode() == 503 && rsp.getDelay() > 0L && !rsp.getResponseHeaders().containsKey("Retry-After")) {
                String retryAfter = Long.toString(rsp.getDelay() / 1000L);
                headers.put("Retry-After", Collections.singletonList(retryAfter));
            }
        }
        if ((tCounter = (ThrottlingCounter)message.getExchange().get(ThrottlingCounter.class)) != null) {
            tCounter.decrementAndGet();
        }
    }
}

