/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.LastModifiedTests;
import org.apache.commons.vfs2.VfsTestUtils;
import org.junit.Test;

public class FtpMdtmOffLastModifiedTests
extends LastModifiedTests {
    @Test
    public void testGetLastModifiedFileInexactMatch() throws IOException {
        String fileName = "file1.txt";
        this.getFileSystem().getFileSystemManager().getFilesCache().clear(this.getFileSystem());
        FileObject readFolder = this.getReadFolder();
        FileObject fileObject = readFolder.resolveFile("file1.txt");
        long lastModifiedTimeMillis = fileObject.getContent().getLastModifiedTime();
        long lastModTimeAccuracyMillis = (long)readFolder.getFileSystem().getLastModTimeAccuracy();
        FileTime lastModifiedTime = Files.getLastModifiedTime(Paths.get(VfsTestUtils.getTestDirectory(), "read-tests", "file1.txt"), new LinkOption[0]);
        this.assertDeltaMillis("getLastModified on File", lastModifiedTime.toMillis(), lastModifiedTimeMillis, Math.max(lastModTimeAccuracyMillis, Duration.ofMinutes(1L).toMillis()));
    }
}

