/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.integration;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math4.legacy.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;

public class SimpsonIntegrator
extends BaseAbstractUnivariateIntegrator {
    private static final int SIMPSON_MAX_ITERATIONS_COUNT = 30;

    public SimpsonIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) {
        super(relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 30) {
            throw new NumberIsTooLargeException((Number)maximalIterationCount, (Number)30, false);
        }
    }

    public SimpsonIntegrator(int minimalIterationCount, int maximalIterationCount) {
        super(minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 30) {
            throw new NumberIsTooLargeException((Number)maximalIterationCount, (Number)30, false);
        }
    }

    public SimpsonIntegrator() {
        super(3, 30);
    }

    @Override
    protected double doIntegrate() {
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        double s0 = qtrap.stage(this, 0);
        double oldt = qtrap.stage(this, 1);
        double olds = (4.0 * oldt - s0) / 3.0;
        while (true) {
            double rLimit;
            double delta;
            this.iterations.increment();
            int i = this.getIterations();
            double t = qtrap.stage(this, i + 1);
            double s = (4.0 * t - oldt) / 3.0;
            if (i >= this.getMinimalIterationCount() && ((delta = JdkMath.abs((double)(s - olds))) <= (rLimit = this.getRelativeAccuracy() * (JdkMath.abs((double)olds) + JdkMath.abs((double)s)) * 0.5) || delta <= this.getAbsoluteAccuracy())) {
                return s;
            }
            olds = s;
            oldt = t;
        }
    }
}

