/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.JacobianMatrices;
import org.apache.commons.math3.ode.MainStateJacobianProvider;
import org.apache.commons.math3.ode.ParameterJacobianProvider;
import org.apache.commons.math3.ode.ParameterizedODE;
import org.apache.commons.math3.ode.UnknownParameterException;
import org.apache.commons.math3.ode.nonstiff.DormandPrince54Integrator;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class JacobianMatricesTest {
    @Test
    public void testLowAccuracyExternalDifferentiation() throws NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException {
        DormandPrince54Integrator integ = new DormandPrince54Integrator(1.0E-8, 100.0, new double[]{1.0E-4, 1.0E-4}, new double[]{1.0E-4, 1.0E-4});
        double hP = 1.0E-12;
        SummaryStatistics residualsP0 = new SummaryStatistics();
        SummaryStatistics residualsP1 = new SummaryStatistics();
        for (double b = 2.88; b < 3.08; b += 0.001) {
            Brusselator brusselator = new Brusselator(b);
            double[] y = new double[]{1.3, b};
            integ.integrate((FirstOrderDifferentialEquations)brusselator, 0.0, y, 20.0, y);
            double[] yP = new double[]{1.3, b + hP};
            integ.integrate((FirstOrderDifferentialEquations)brusselator, 0.0, yP, 20.0, yP);
            residualsP0.addValue((yP[0] - y[0]) / hP - brusselator.dYdP0());
            residualsP1.addValue((yP[1] - y[1]) / hP - brusselator.dYdP1());
        }
        Assert.assertTrue((residualsP0.getMax() - residualsP0.getMin() > 500.0 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP0.getStandardDeviation() > 30.0 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getMax() - residualsP1.getMin() > 700.0 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getStandardDeviation() > 40.0 ? 1 : 0) != 0);
    }

    @Test
    public void testHighAccuracyExternalDifferentiation() throws NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException, UnknownParameterException {
        DormandPrince54Integrator integ = new DormandPrince54Integrator(1.0E-8, 100.0, new double[]{1.0E-10, 1.0E-10}, new double[]{1.0E-10, 1.0E-10});
        double hP = 1.0E-12;
        SummaryStatistics residualsP0 = new SummaryStatistics();
        SummaryStatistics residualsP1 = new SummaryStatistics();
        for (double b = 2.88; b < 3.08; b += 0.001) {
            ParamBrusselator brusselator = new ParamBrusselator(b);
            double[] y = new double[]{1.3, b};
            integ.integrate((FirstOrderDifferentialEquations)brusselator, 0.0, y, 20.0, y);
            double[] yP = new double[]{1.3, b + hP};
            brusselator.setParameter("b", b + hP);
            integ.integrate((FirstOrderDifferentialEquations)brusselator, 0.0, yP, 20.0, yP);
            residualsP0.addValue((yP[0] - y[0]) / hP - brusselator.dYdP0());
            residualsP1.addValue((yP[1] - y[1]) / hP - brusselator.dYdP1());
        }
        Assert.assertTrue((residualsP0.getMax() - residualsP0.getMin() > 0.02 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP0.getMax() - residualsP0.getMin() < 0.03 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP0.getStandardDeviation() > 0.003 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP0.getStandardDeviation() < 0.004 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getMax() - residualsP1.getMin() > 0.04 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getMax() - residualsP1.getMin() < 0.05 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getStandardDeviation() > 0.007 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getStandardDeviation() < 0.008 ? 1 : 0) != 0);
    }

    @Test
    public void testWrongParameterName() {
        String name = "an-unknown-parameter";
        try {
            ParamBrusselator brusselator = new ParamBrusselator(2.9);
            brusselator.setParameter("an-unknown-parameter", 3.0);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (UnknownParameterException upe) {
            Assert.assertTrue((boolean)upe.getMessage().contains("an-unknown-parameter"));
            Assert.assertEquals((Object)"an-unknown-parameter", (Object)upe.getName());
        }
    }

    @Test
    public void testInternalDifferentiation() throws NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException, UnknownParameterException, JacobianMatrices.MismatchedEquations {
        DormandPrince54Integrator integ = new DormandPrince54Integrator(1.0E-8, 100.0, new double[]{1.0E-4, 1.0E-4}, new double[]{1.0E-4, 1.0E-4});
        double hP = 1.0E-12;
        double hY = 1.0E-12;
        SummaryStatistics residualsP0 = new SummaryStatistics();
        SummaryStatistics residualsP1 = new SummaryStatistics();
        for (double b = 2.88; b < 3.08; b += 0.001) {
            ParamBrusselator brusselator = new ParamBrusselator(b);
            brusselator.setParameter("b", b);
            double[] z = new double[]{1.3, b};
            double[][] dZdZ0 = new double[2][2];
            double[] dZdP = new double[2];
            JacobianMatrices jacob = new JacobianMatrices((FirstOrderDifferentialEquations)brusselator, new double[]{hY, hY}, new String[]{"b"});
            jacob.setParameterizedODE((ParameterizedODE)brusselator);
            jacob.setParameterStep("b", hP);
            jacob.setInitialParameterJacobian("b", new double[]{0.0, 1.0});
            ExpandableStatefulODE efode = new ExpandableStatefulODE((FirstOrderDifferentialEquations)brusselator);
            efode.setTime(0.0);
            efode.setPrimaryState(z);
            jacob.registerVariationalEquations(efode);
            integ.setMaxEvaluations(5000);
            integ.integrate(efode, 20.0);
            jacob.getCurrentMainSetJacobian(dZdZ0);
            jacob.getCurrentParameterJacobian("b", dZdP);
            residualsP0.addValue(dZdP[0] - brusselator.dYdP0());
            residualsP1.addValue(dZdP[1] - brusselator.dYdP1());
        }
        Assert.assertTrue((residualsP0.getMax() - residualsP0.getMin() < 0.02 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP0.getStandardDeviation() < 0.003 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getMax() - residualsP1.getMin() < 0.05 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getStandardDeviation() < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testAnalyticalDifferentiation() throws MaxCountExceededException, DimensionMismatchException, NumberIsTooSmallException, NoBracketingException, UnknownParameterException, JacobianMatrices.MismatchedEquations {
        DormandPrince54Integrator integ = new DormandPrince54Integrator(1.0E-8, 100.0, new double[]{1.0E-4, 1.0E-4}, new double[]{1.0E-4, 1.0E-4});
        SummaryStatistics residualsP0 = new SummaryStatistics();
        SummaryStatistics residualsP1 = new SummaryStatistics();
        for (double b = 2.88; b < 3.08; b += 0.001) {
            Brusselator brusselator = new Brusselator(b);
            double[] z = new double[]{1.3, b};
            double[][] dZdZ0 = new double[2][2];
            double[] dZdP = new double[2];
            JacobianMatrices jacob = new JacobianMatrices((MainStateJacobianProvider)brusselator, new String[]{"b"});
            jacob.addParameterJacobianProvider((ParameterJacobianProvider)brusselator);
            jacob.setInitialParameterJacobian("b", new double[]{0.0, 1.0});
            ExpandableStatefulODE efode = new ExpandableStatefulODE((FirstOrderDifferentialEquations)brusselator);
            efode.setTime(0.0);
            efode.setPrimaryState(z);
            jacob.registerVariationalEquations(efode);
            integ.setMaxEvaluations(5000);
            integ.integrate(efode, 20.0);
            jacob.getCurrentMainSetJacobian(dZdZ0);
            jacob.getCurrentParameterJacobian("b", dZdP);
            residualsP0.addValue(dZdP[0] - brusselator.dYdP0());
            residualsP1.addValue(dZdP[1] - brusselator.dYdP1());
        }
        Assert.assertTrue((residualsP0.getMax() - residualsP0.getMin() < 0.014 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP0.getStandardDeviation() < 0.003 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getMax() - residualsP1.getMin() < 0.05 ? 1 : 0) != 0);
        Assert.assertTrue((residualsP1.getStandardDeviation() < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testFinalResult() throws MaxCountExceededException, DimensionMismatchException, NumberIsTooSmallException, NoBracketingException, UnknownParameterException, JacobianMatrices.MismatchedEquations {
        DormandPrince54Integrator integ = new DormandPrince54Integrator(1.0E-8, 100.0, new double[]{1.0E-10, 1.0E-10}, new double[]{1.0E-10, 1.0E-10});
        double[] y = new double[]{0.0, 1.0};
        Circle circle = new Circle(y, 1.0, 1.0, 0.1);
        JacobianMatrices jacob = new JacobianMatrices((MainStateJacobianProvider)circle, new String[]{"cx", "cy", "omega"});
        jacob.addParameterJacobianProvider((ParameterJacobianProvider)circle);
        jacob.setInitialMainStateJacobian(circle.exactDyDy0(0.0));
        jacob.setInitialParameterJacobian("cx", circle.exactDyDcx(0.0));
        jacob.setInitialParameterJacobian("cy", circle.exactDyDcy(0.0));
        jacob.setInitialParameterJacobian("omega", circle.exactDyDom(0.0));
        ExpandableStatefulODE efode = new ExpandableStatefulODE((FirstOrderDifferentialEquations)circle);
        efode.setTime(0.0);
        efode.setPrimaryState(y);
        jacob.registerVariationalEquations(efode);
        integ.setMaxEvaluations(5000);
        double t = 56.548667764616276;
        integ.integrate(efode, t);
        y = efode.getPrimaryState();
        for (int i = 0; i < y.length; ++i) {
            Assert.assertEquals((double)circle.exactY(t)[i], (double)y[i], (double)1.0E-9);
        }
        double[][] dydy0 = new double[2][2];
        jacob.getCurrentMainSetJacobian(dydy0);
        for (int i = 0; i < dydy0.length; ++i) {
            for (int j = 0; j < dydy0[i].length; ++j) {
                Assert.assertEquals((double)circle.exactDyDy0(t)[i][j], (double)dydy0[i][j], (double)1.0E-9);
            }
        }
        double[] dydcx = new double[2];
        jacob.getCurrentParameterJacobian("cx", dydcx);
        for (int i = 0; i < dydcx.length; ++i) {
            Assert.assertEquals((double)circle.exactDyDcx(t)[i], (double)dydcx[i], (double)1.0E-7);
        }
        double[] dydcy = new double[2];
        jacob.getCurrentParameterJacobian("cy", dydcy);
        for (int i = 0; i < dydcy.length; ++i) {
            Assert.assertEquals((double)circle.exactDyDcy(t)[i], (double)dydcy[i], (double)1.0E-7);
        }
        double[] dydom = new double[2];
        jacob.getCurrentParameterJacobian("omega", dydom);
        for (int i = 0; i < dydom.length; ++i) {
            Assert.assertEquals((double)circle.exactDyDom(t)[i], (double)dydom[i], (double)1.0E-7);
        }
    }

    @Test
    public void testParameterizable() throws MaxCountExceededException, DimensionMismatchException, NumberIsTooSmallException, NoBracketingException, UnknownParameterException, JacobianMatrices.MismatchedEquations {
        DormandPrince54Integrator integ = new DormandPrince54Integrator(1.0E-8, 100.0, new double[]{1.0E-10, 1.0E-10}, new double[]{1.0E-10, 1.0E-10});
        double[] y = new double[]{0.0, 1.0};
        ParameterizedCircle pcircle = new ParameterizedCircle(y, 1.0, 1.0, 0.1);
        double hP = 1.0E-12;
        double hY = 1.0E-12;
        JacobianMatrices jacob = new JacobianMatrices((FirstOrderDifferentialEquations)pcircle, new double[]{hY, hY}, new String[]{"cx", "cy", "omega"});
        jacob.setParameterizedODE((ParameterizedODE)pcircle);
        jacob.setParameterStep("cx", hP);
        jacob.setParameterStep("cy", hP);
        jacob.setParameterStep("omega", hP);
        jacob.setInitialMainStateJacobian(pcircle.exactDyDy0(0.0));
        jacob.setInitialParameterJacobian("cx", pcircle.exactDyDcx(0.0));
        jacob.setInitialParameterJacobian("cy", pcircle.exactDyDcy(0.0));
        jacob.setInitialParameterJacobian("omega", pcircle.exactDyDom(0.0));
        ExpandableStatefulODE efode = new ExpandableStatefulODE((FirstOrderDifferentialEquations)pcircle);
        efode.setTime(0.0);
        efode.setPrimaryState(y);
        jacob.registerVariationalEquations(efode);
        integ.setMaxEvaluations(50000);
        double t = 56.548667764616276;
        integ.integrate(efode, t);
        y = efode.getPrimaryState();
        for (int i = 0; i < y.length; ++i) {
            Assert.assertEquals((double)pcircle.exactY(t)[i], (double)y[i], (double)1.0E-9);
        }
        double[][] dydy0 = new double[2][2];
        jacob.getCurrentMainSetJacobian(dydy0);
        for (int i = 0; i < dydy0.length; ++i) {
            for (int j = 0; j < dydy0[i].length; ++j) {
                Assert.assertEquals((double)pcircle.exactDyDy0(t)[i][j], (double)dydy0[i][j], (double)5.0E-4);
            }
        }
        double[] dydp0 = new double[2];
        jacob.getCurrentParameterJacobian("cx", dydp0);
        for (int i = 0; i < dydp0.length; ++i) {
            Assert.assertEquals((double)pcircle.exactDyDcx(t)[i], (double)dydp0[i], (double)5.0E-4);
        }
        double[] dydp1 = new double[2];
        jacob.getCurrentParameterJacobian("omega", dydp1);
        for (int i = 0; i < dydp1.length; ++i) {
            Assert.assertEquals((double)pcircle.exactDyDom(t)[i], (double)dydp1[i], (double)0.01);
        }
    }

    private static class ParameterizedCircle
    extends AbstractParameterizable
    implements FirstOrderDifferentialEquations,
    ParameterizedODE {
        public static final String CX = "cx";
        public static final String CY = "cy";
        public static final String OMEGA = "omega";
        private final double[] y0;
        private double cx;
        private double cy;
        private double omega;

        public ParameterizedCircle(double[] y0, double cx, double cy, double omega) {
            super(new String[]{CX, CY, OMEGA});
            this.y0 = (double[])y0.clone();
            this.cx = cx;
            this.cy = cy;
            this.omega = omega;
        }

        public int getDimension() {
            return 2;
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) {
            yDot[0] = this.omega * (this.cy - y[1]);
            yDot[1] = this.omega * (y[0] - this.cx);
        }

        public double getParameter(String name) throws UnknownParameterException {
            if (name.equals(CX)) {
                return this.cx;
            }
            if (name.equals(CY)) {
                return this.cy;
            }
            if (name.equals(OMEGA)) {
                return this.omega;
            }
            throw new UnknownParameterException(name);
        }

        public void setParameter(String name, double value) throws UnknownParameterException {
            if (name.equals(CX)) {
                this.cx = value;
            } else if (name.equals(CY)) {
                this.cy = value;
            } else if (name.equals(OMEGA)) {
                this.omega = value;
            } else {
                throw new UnknownParameterException(name);
            }
        }

        public double[] exactY(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            double dx0 = this.y0[0] - this.cx;
            double dy0 = this.y0[1] - this.cy;
            return new double[]{this.cx + cos * dx0 - sin * dy0, this.cy + sin * dx0 + cos * dy0};
        }

        public double[][] exactDyDy0(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            return new double[][]{{cos, -sin}, {sin, cos}};
        }

        public double[] exactDyDcx(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            return new double[]{1.0 - cos, -sin};
        }

        public double[] exactDyDcy(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            return new double[]{sin, 1.0 - cos};
        }

        public double[] exactDyDom(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            double dx0 = this.y0[0] - this.cx;
            double dy0 = this.y0[1] - this.cy;
            return new double[]{-t * (sin * dx0 + cos * dy0), t * (cos * dx0 - sin * dy0)};
        }
    }

    private static class Circle
    extends AbstractParameterizable
    implements MainStateJacobianProvider,
    ParameterJacobianProvider {
        public static final String CX = "cx";
        public static final String CY = "cy";
        public static final String OMEGA = "omega";
        private final double[] y0;
        private double cx;
        private double cy;
        private double omega;

        public Circle(double[] y0, double cx, double cy, double omega) {
            super(new String[]{CX, CY, OMEGA});
            this.y0 = (double[])y0.clone();
            this.cx = cx;
            this.cy = cy;
            this.omega = omega;
        }

        public int getDimension() {
            return 2;
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) {
            yDot[0] = this.omega * (this.cy - y[1]);
            yDot[1] = this.omega * (y[0] - this.cx);
        }

        public void computeMainStateJacobian(double t, double[] y, double[] yDot, double[][] dFdY) {
            dFdY[0][0] = 0.0;
            dFdY[0][1] = -this.omega;
            dFdY[1][0] = this.omega;
            dFdY[1][1] = 0.0;
        }

        public void computeParameterJacobian(double t, double[] y, double[] yDot, String paramName, double[] dFdP) throws UnknownParameterException {
            this.complainIfNotSupported(paramName);
            if (paramName.equals(CX)) {
                dFdP[0] = 0.0;
                dFdP[1] = -this.omega;
            } else if (paramName.equals(CY)) {
                dFdP[0] = this.omega;
                dFdP[1] = 0.0;
            } else {
                dFdP[0] = this.cy - y[1];
                dFdP[1] = y[0] - this.cx;
            }
        }

        public double[] exactY(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            double dx0 = this.y0[0] - this.cx;
            double dy0 = this.y0[1] - this.cy;
            return new double[]{this.cx + cos * dx0 - sin * dy0, this.cy + sin * dx0 + cos * dy0};
        }

        public double[][] exactDyDy0(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            return new double[][]{{cos, -sin}, {sin, cos}};
        }

        public double[] exactDyDcx(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            return new double[]{1.0 - cos, -sin};
        }

        public double[] exactDyDcy(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            return new double[]{sin, 1.0 - cos};
        }

        public double[] exactDyDom(double t) {
            double cos = FastMath.cos((double)(this.omega * t));
            double sin = FastMath.sin((double)(this.omega * t));
            double dx0 = this.y0[0] - this.cx;
            double dy0 = this.y0[1] - this.cy;
            return new double[]{-t * (sin * dx0 + cos * dy0), t * (cos * dx0 - sin * dy0)};
        }
    }

    private static class ParamBrusselator
    extends AbstractParameterizable
    implements FirstOrderDifferentialEquations,
    ParameterizedODE {
        public static final String B = "b";
        private double b;

        public ParamBrusselator(double b) {
            super(new String[]{B});
            this.b = b;
        }

        public int getDimension() {
            return 2;
        }

        public double getParameter(String name) throws UnknownParameterException {
            this.complainIfNotSupported(name);
            return this.b;
        }

        public void setParameter(String name, double value) throws UnknownParameterException {
            this.complainIfNotSupported(name);
            this.b = value;
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) {
            double prod = y[0] * y[0] * y[1];
            yDot[0] = 1.0 + prod - (this.b + 1.0) * y[0];
            yDot[1] = this.b * y[0] - prod;
        }

        public double dYdP0() {
            return -1088.232716447743 + (1050.775747149553 + (-339.012934631828 + 36.52917025056327 * this.b) * this.b) * this.b;
        }

        public double dYdP1() {
            return 1502.824469929139 + (-1438.6974831849952 + (460.959476642384 - 49.43847385647082 * this.b) * this.b) * this.b;
        }
    }

    private static class Brusselator
    extends AbstractParameterizable
    implements MainStateJacobianProvider,
    ParameterJacobianProvider {
        public static final String B = "b";
        private double b;

        public Brusselator(double b) {
            super(new String[]{B});
            this.b = b;
        }

        public int getDimension() {
            return 2;
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) {
            double prod = y[0] * y[0] * y[1];
            yDot[0] = 1.0 + prod - (this.b + 1.0) * y[0];
            yDot[1] = this.b * y[0] - prod;
        }

        public void computeMainStateJacobian(double t, double[] y, double[] yDot, double[][] dFdY) {
            double p = 2.0 * y[0] * y[1];
            double y02 = y[0] * y[0];
            dFdY[0][0] = p - (1.0 + this.b);
            dFdY[0][1] = y02;
            dFdY[1][0] = this.b - p;
            dFdY[1][1] = -y02;
        }

        public void computeParameterJacobian(double t, double[] y, double[] yDot, String paramName, double[] dFdP) {
            if (this.isSupported(paramName)) {
                dFdP[0] = -y[0];
                dFdP[1] = y[0];
            } else {
                dFdP[0] = 0.0;
                dFdP[1] = 0.0;
            }
        }

        public double dYdP0() {
            return -1088.232716447743 + (1050.775747149553 + (-339.012934631828 + 36.52917025056327 * this.b) * this.b) * this.b;
        }

        public double dYdP1() {
            return 1502.824469929139 + (-1438.6974831849952 + (460.959476642384 - 49.43847385647082 * this.b) * this.b) * this.b;
        }
    }
}

