/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl3.Foo;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MethodTest
extends JexlTestCase {
    private Asserter asserter;
    private static final String METHOD_STRING = "Method string";

    public MethodTest() {
        super("MethodTest");
    }

    @Override
    @Before
    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
    }

    @Test
    public void testCallVarArgMethod() throws Exception {
        VarArgs test = new VarArgs();
        this.asserter.setVariable("test", test);
        this.asserter.assertExpression("test.callInts()", test.callInts());
        this.asserter.assertExpression("test.callInts(1)", test.callInts(1));
        this.asserter.assertExpression("test.callInts(1,2,3,4,5)", test.callInts(1, 2, 3, 4, 5));
        this.asserter.assertExpression("test.concat(['1', '2', '3'])", test.concat("1", "2", "3"));
        this.asserter.assertExpression("test.concat('1', '2', '3')", test.concat("1", "2", "3"));
    }

    @Test
    public void testCallMixedVarArgMethod() throws Exception {
        VarArgs test = new VarArgs();
        this.asserter.setVariable("test", test);
        Assert.assertEquals((Object)"Mixed:1", (Object)test.callMixed(1, new Integer[0]));
        this.asserter.assertExpression("test.callMixed(1)", test.callMixed(1, new Integer[0]));
        Assert.assertEquals((Object)"Mixed:-999", (Object)test.callMixed(1, (Integer[])null));
        this.asserter.assertExpression("test.callMixed(1, null)", "Mixed:-999");
        this.asserter.assertExpression("test.callMixed(1,2)", test.callMixed(1, 2));
        this.asserter.assertExpression("test.callMixed(1,2,3,4,5)", test.callMixed(1, 2, 3, 4, 5));
    }

    @Test
    public void testCallJexlVarArgMethod() throws Exception {
        VarArgs test = new VarArgs();
        this.asserter.setVariable("test", test);
        Assert.assertEquals((Object)"jexl:0", (Object)test.callMixed("jexl", new Integer[0]));
        this.asserter.assertExpression("test.callMixed('jexl')", "jexl:0");
        Assert.assertEquals((Object)"jexl:-1000", (Object)test.callMixed("jexl", (Integer[])null));
        this.asserter.assertExpression("test.callMixed('jexl', null)", "jexl:-1000");
        this.asserter.assertExpression("test.callMixed('jexl', 2)", test.callMixed("jexl", 2));
        this.asserter.assertExpression("test.callMixed('jexl',2,3,4,5)", test.callMixed("jexl", 2, 3, 4, 5));
    }

    @Test
    public void testInvoke() throws Exception {
        Object result;
        Functor func = new Functor();
        Assert.assertEquals((Object)10, (Object)this.JEXL.invokeMethod((Object)func, "ten", new Object[0]));
        Assert.assertEquals((Object)42, (Object)this.JEXL.invokeMethod((Object)func, "PLUS20", new Object[]{22}));
        try {
            this.JEXL.invokeMethod((Object)func, "nonExistentMethod", new Object[0]);
            Assert.fail((String)"method does not exist!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.JEXL.invokeMethod((Object)func, "NPEIfNull", (Object[])null);
            Assert.fail((String)"method should have thrown!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result = this.JEXL.invokeMethod((Object)func, "over", new Object[]{"foo", 42});
            Assert.assertEquals((Object)"foo + 42", (Object)result);
        }
        catch (Exception xj0) {
            result = xj0;
        }
        try {
            result = this.JEXL.invokeMethod((Object)func, "over", new Object[]{null, null});
            Assert.fail((String)"method should have thrown!");
        }
        catch (Exception xj0) {
            result = xj0;
        }
        func = new FunctorOver();
        try {
            result = this.JEXL.invokeMethod((Object)func, "over", new Object[]{null, null});
            Assert.assertEquals((Object)"null + null", (Object)result);
        }
        catch (Exception xj0) {
            Assert.fail((String)"method should not have thrown!");
        }
    }

    @Test
    public void testAmbiguousInvoke() throws Exception {
        Functor func = new Functor();
        MapContext ctxt = new MapContext();
        ctxt.set("func", (Object)func);
        Object result = this.JEXL.invokeMethod((Object)func, "over", new Object[]{"foo", 42});
        Assert.assertEquals((Object)"foo + 42", (Object)result);
        try {
            this.JEXL.invokeMethod((Object)func, "over", new Object[]{"not null", null});
            Assert.fail((String)"should be ambiguous");
        }
        catch (JexlException.Method xinvoke) {
            Assert.assertEquals((Object)"over(String, Object)", (Object)xinvoke.getMethodSignature());
        }
        try {
            String[] arg2 = new String[]{"more", "than", "one"};
            this.JEXL.invokeMethod((Object)func, "over", new Object[]{"not null", arg2});
            Assert.fail((String)"should be ambiguous");
        }
        catch (JexlException.Method xinvoke) {
            Assert.assertEquals((Object)"over(String, String[])", (Object)xinvoke.getMethodSignature());
        }
    }

    @Test
    public void testTryFailed() throws Exception {
        Functor func = new Functor();
        MapContext ctxt = new MapContext();
        ctxt.set("func", (Object)func);
        JexlUberspect uber = this.JEXL.getUberspect();
        JexlMethod method = uber.getMethod((Object)func, "over", new Object[]{"foo", 42});
        Assert.assertNotNull((Object)method);
        Object result = method.tryInvoke("over", (Object)func, new Object[]{"foo", 42});
        Assert.assertEquals((Object)"foo + 42", (Object)result);
        func.setKill(true);
        try {
            method.tryInvoke("over", (Object)func, new Object[]{"foo", 42});
            Assert.fail((String)"should throw TryFailed");
        }
        catch (JexlException.TryFailed xfail) {
            Assert.assertEquals(UnsupportedOperationException.class, xfail.getCause().getClass());
        }
        func.setKill(false);
        JexlPropertySet setter = uber.getPropertySet((Object)func, (Object)"under", (Object)"42");
        result = setter.tryInvoke((Object)func, (Object)"under", (Object)"42");
        Assert.assertFalse((boolean)setter.tryFailed(result));
        Assert.assertEquals((Object)"42", (Object)result);
        JexlPropertyGet getter = uber.getPropertyGet((Object)func, (Object)"under");
        result = getter.tryInvoke((Object)func, (Object)"under");
        Assert.assertFalse((boolean)getter.tryFailed(result));
        Assert.assertEquals((Object)"42", (Object)result);
        func.setKill(true);
        try {
            setter.tryInvoke((Object)func, (Object)"under", (Object)"42");
            Assert.fail((String)"should throw TryFailed");
        }
        catch (JexlException.TryFailed xfail) {
            Assert.assertEquals(UnsupportedOperationException.class, xfail.getCause().getClass());
        }
        func.setKill(false);
        result = setter.tryInvoke((Object)func, (Object)"under", (Object)"-42");
        Assert.assertEquals((Object)"-42", (Object)result);
        func.setKill(true);
        try {
            getter.tryInvoke((Object)func, (Object)"under");
            Assert.fail((String)"should throw TryFailed");
        }
        catch (JexlException.TryFailed xfail) {
            Assert.assertEquals(UnsupportedOperationException.class, xfail.getCause().getClass());
        }
        func.setKill(false);
        result = getter.tryInvoke((Object)func, (Object)"under");
        Assert.assertFalse((boolean)getter.tryFailed(result));
        Assert.assertEquals((Object)"-42", (Object)result);
    }

    @Test
    public void testTryFailedScript() throws Exception {
        Functor func = new Functor();
        MapContext ctxt = new MapContext();
        ctxt.set("func", (Object)func);
        JexlUberspect uber = this.JEXL.getUberspect();
        JexlScript method = this.JEXL.createScript("(x, y)->{ func.over(x, y) }");
        Assert.assertNotNull((Object)method);
        Object result = method.execute((JexlContext)ctxt, new Object[]{"foo", 42});
        Assert.assertEquals((Object)"foo + 42", (Object)result);
        func.setKill(true);
        try {
            method.execute((JexlContext)ctxt, new Object[]{"foo", 42});
            Assert.fail((String)"should throw TryFailed");
        }
        catch (JexlException xfail) {
            Assert.assertEquals(UnsupportedOperationException.class, xfail.getCause().getClass());
        }
        func.setKill(false);
        JexlScript setter = this.JEXL.createScript("(x)->{ func.under = x }");
        result = setter.execute((JexlContext)ctxt, new Object[]{"42"});
        Assert.assertEquals((Object)"42", (Object)result);
        JexlScript getter = this.JEXL.createScript("func.under");
        Assert.assertEquals((Object)"42", (Object)result);
        func.setKill(true);
        try {
            setter.execute((JexlContext)ctxt, new Object[]{"42"});
            Assert.fail((String)"should throw TryFailed");
        }
        catch (JexlException xfail) {
            Assert.assertEquals(UnsupportedOperationException.class, xfail.getCause().getClass());
        }
        func.setKill(false);
        result = setter.execute((JexlContext)ctxt, new Object[]{"-42"});
        Assert.assertEquals((Object)"-42", (Object)result);
        func.setKill(true);
        try {
            getter.execute((JexlContext)ctxt);
            Assert.fail((String)"should throw TryFailed");
        }
        catch (JexlException xfail) {
            Assert.assertEquals(UnsupportedOperationException.class, xfail.getCause().getClass());
        }
        func.setKill(false);
        result = getter.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)"-42", (Object)result);
    }

    @Test
    public void testMethod() throws Exception {
        this.asserter.setVariable("foo", new Foo());
        this.asserter.assertExpression("foo.bar()", METHOD_STRING);
    }

    @Test
    public void testMulti() throws Exception {
        this.asserter.setVariable("foo", new Foo());
        this.asserter.assertExpression("foo.innerFoo.bar()", METHOD_STRING);
    }

    @Test
    public void testStringMethods() throws Exception {
        this.asserter.setVariable("foo", "abcdef");
        this.asserter.assertExpression("foo.substring(3)", "def");
        this.asserter.assertExpression("foo.substring(0,(size(foo)-3))", "abc");
        this.asserter.assertExpression("foo.substring(0,size(foo)-3)", "abc");
        this.asserter.assertExpression("foo.substring(0,foo.length()-3)", "abc");
        this.asserter.assertExpression("foo.substring(0, 1+1)", "ab");
    }

    @Test
    public void testStaticMethodInvocation() throws Exception {
        this.asserter.setVariable("aBool", Boolean.FALSE);
        this.asserter.assertExpression("aBool.valueOf('true')", Boolean.TRUE);
    }

    @Test
    public void testStaticMethodInvocationOnClasses() throws Exception {
        this.asserter.setVariable("Boolean", Boolean.class);
        this.asserter.assertExpression("Boolean.valueOf('true')", Boolean.TRUE);
    }

    @Test
    public void testTopLevelCall() throws Exception {
        HashMap<String, Object> funcs = new HashMap<String, Object>();
        funcs.put(null, new Functor());
        funcs.put("math", new MyMath());
        funcs.put("cx", ContextualFunctor.class);
        EnhancedContext jc = new EnhancedContext(funcs);
        JexlExpression e = this.JEXL.createExpression("ten()");
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        e = this.JEXL.createExpression("plus10(10)");
        o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 20", (Object)new Integer(20), (Object)o);
        e = this.JEXL.createExpression("plus10(ten())");
        o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 20", (Object)new Integer(20), (Object)o);
        jc.set("pi", new Double(Math.PI));
        e = this.JEXL.createExpression("math:cos(pi)");
        o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)-1.0, (Object)o);
        e = this.JEXL.createExpression("cx:ratio(10) + cx:ratio(20)");
        o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)7, (Object)o);
    }

    @Test
    public void testNamespaceCall() throws Exception {
        HashMap<String, Object> funcs = new HashMap<String, Object>();
        funcs.put("func", new Functor());
        funcs.put("FUNC", Functor.class);
        JexlExpression e = this.JEXL.createExpression("func:ten()");
        EnhancedContext jc = new EnhancedContext(funcs);
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        e = this.JEXL.createExpression("func:plus10(10)");
        o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 20", (Object)new Integer(20), (Object)o);
        e = this.JEXL.createExpression("func:plus10(func:ten())");
        o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 20", (Object)new Integer(20), (Object)o);
        e = this.JEXL.createExpression("FUNC:PLUS20(10)");
        o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 30", (Object)new Integer(30), (Object)o);
        e = this.JEXL.createExpression("FUNC:PLUS20(FUNC:TWENTY())");
        o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 40", (Object)new Integer(40), (Object)o);
    }

    private boolean eqExecute(Object lhs, Object rhs) {
        if (lhs instanceof Class[] && rhs instanceof Class[]) {
            Object[] lhsa = (Class[])lhs;
            Object[] rhsa = (Class[])rhs;
            return Arrays.deepEquals(lhsa, rhsa);
        }
        return false;
    }

    @Test
    public void testNamespaceCallEdge() throws Exception {
        HashMap<String, Object> funcs = new HashMap<String, Object>();
        Edge func = new Edge();
        funcs.put("func", func);
        EnhancedContext jc = new EnhancedContext(funcs);
        try {
            for (int i = 0; i < 2; ++i) {
                JexlExpression e = this.JEXL.createExpression("func:exec([1, 2])");
                Object o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(int[] arg): " + i), (Object)20, (Object)o);
                e = this.JEXL.createExpression("func:exec(1, 2)");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(Object... args): " + i), (Object)4, (Object)o);
                e = this.JEXL.createExpression("func:exec([10.0, 20.0])");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(Object args): " + i), (Object)3, (Object)o);
                e = this.JEXL.createExpression("func:exec('1', 2)");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(Object... args): " + i), (Object)4, (Object)o);
                Assert.assertEquals((String)("exec(String... args): " + i), (long)func.exec("1", "2"), (long)func.exec("1", "2"));
                e = this.JEXL.createExpression("func:exec(['1', '2'])");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(String... args): " + i), (Object)func.exec("1", "2"), (Object)o);
                e = this.JEXL.createExpression("func:exec('1', '2')");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(String... args): " + i), (Object)func.exec("1", "2"), (Object)o);
                e = this.JEXL.createExpression("func:exec(true, [1, 2])");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(int[] arg): " + i), (Object)20, (Object)o);
                e = this.JEXL.createExpression("func:exec(true, 1, 2)");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(Object... args): " + i), (Object)4, (Object)o);
                e = this.JEXL.createExpression("func:exec(true, ['1', '2'])");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(Object args): " + i), (Object)3, (Object)o);
                e = this.JEXL.createExpression("func:exec(true, '1', '2')");
                o = e.evaluate((JexlContext)jc);
                Assert.assertEquals((String)("exec(Object... args): " + i), (Object)4, (Object)o);
                e = this.JEXL.createExpression("func:execute(true, '1', '2')");
                o = e.evaluate((JexlContext)jc);
                Class<?>[] c = func.execute(Boolean.TRUE, "1", "2");
                Assert.assertTrue((String)("execute(Object... args): " + i), (boolean)this.eqExecute(o, c));
                e = this.JEXL.createExpression("func:execute([true])");
                o = e.evaluate((JexlContext)jc);
                c = func.execute(new Object[]{new boolean[]{true}});
                Assert.assertTrue((String)("execute(Object... args): " + i), (boolean)this.eqExecute(o, c));
            }
        }
        catch (JexlException xjexl) {
            Assert.fail((String)xjexl.toString());
        }
    }

    @Test
    public void testScriptCall() throws Exception {
        MapContext context = new MapContext();
        JexlScript plus = this.JEXL.createScript("a + b", new String[]{"a", "b"});
        context.set("plus", (Object)plus);
        JexlScript forty2 = this.JEXL.createScript("plus(4, 2) * plus(4, 3)");
        Object o = forty2.execute((JexlContext)context);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        HashMap<String, Object> foo = new HashMap<String, Object>();
        foo.put("plus", plus);
        context.set("foo", foo);
        forty2 = this.JEXL.createScript("foo.plus(4, 2) * foo.plus(4, 3)");
        o = forty2.execute((JexlContext)context);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        context = new ScriptContext(foo);
        forty2 = this.JEXL.createScript("script:plus(4, 2) * script:plus(4, 3)");
        o = forty2.execute((JexlContext)context);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        final JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlMethod mplus = new JexlMethod(){

            public Object invoke(Object obj, Object ... params) throws Exception {
                if (obj instanceof Map) {
                    return ja.add(params[0], params[1]);
                }
                throw new Exception("not a script context");
            }

            public Object tryInvoke(String name, Object obj, Object ... params) {
                try {
                    if ("plus".equals(name)) {
                        return this.invoke(obj, params);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this;
            }

            public boolean tryFailed(Object rval) {
                return rval == this;
            }

            public boolean isCacheable() {
                return true;
            }

            public Class<?> getReturnType() {
                return Object.class;
            }
        };
        foo.put("PLUS", mplus);
        forty2 = this.JEXL.createScript("script:PLUS(4, 2) * script:PLUS(4, 3)");
        o = forty2.execute((JexlContext)context);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        context.set("foo.bar", foo);
        forty2 = this.JEXL.createScript("foo.'bar'.PLUS(4, 2) * foo.bar.PLUS(4, 3)");
        o = forty2.execute((JexlContext)context);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    @Test
    public void testFizzCall() throws Exception {
        ScriptContext context = new ScriptContext(new HashMap<String, Object>());
        JexlScript bar = this.JEXL.createScript("functor:get('drink')");
        Object o = bar.execute((JexlContext)context);
        Assert.assertEquals((String)"Wrong choice", (Object)"champaign", (Object)o);
        context.set("base", "gin");
        o = bar.execute((JexlContext)context);
        Assert.assertEquals((String)"Wrong choice", (Object)"gin fizz", (Object)o);
        context.set("base", "wine");
        bar = this.JEXL.createScript("var glass = functor:get('drink'); base = 'gin'; functor:get('drink')");
        o = bar.execute((JexlContext)context);
        Assert.assertEquals((String)"Wrong choice", (Object)"champaign", (Object)o);
    }

    @Test
    public void testVariousFunctionLocation() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        HashMap<Object, ZSpace> funcs = new HashMap<Object, ZSpace>();
        funcs.put(null, new ZSpace());
        JexlEngine jexl = new JexlBuilder().namespaces(funcs).arithmetic((JexlArithmetic)new ZArithmetic(true)).create();
        ZContext zjc = new ZContext(vars);
        String z41 = "z(41)";
        JexlScript callz41 = jexl.createScript("z(41)");
        Object onovar = callz41.execute((JexlContext)zjc);
        Assert.assertEquals((Object)222, (Object)onovar);
        JexlScript z241 = jexl.createScript("(x)->{ return x + 241}");
        vars.put("z", z241);
        Object oglobal = callz41.execute((JexlContext)zjc);
        Assert.assertEquals((Object)282, (Object)oglobal);
        vars.remove("z");
        onovar = callz41.execute((JexlContext)zjc);
        Assert.assertEquals((Object)222, (Object)onovar);
        String slocal = "var z = (x)->{ return x + 141}; z(1)";
        JexlScript jlocal = jexl.createScript("var z = (x)->{ return x + 141}; z(1)");
        Object olocal = jlocal.execute((JexlContext)zjc);
        Assert.assertEquals((Object)142, (Object)olocal);
        Assert.assertEquals((Object)42, (Object)jexl.createScript("zz(2)").execute((JexlContext)zjc));
        Assert.assertEquals((Object)42, (Object)jexl.createScript("zzz(3)").execute((JexlContext)zjc));
        Assert.assertEquals((Object)42, (Object)jexl.createScript("zzzz(4)").execute((JexlContext)zjc));
    }

    public static class ZContext
    extends MapContext {
        public ZContext(Map<String, Object> map) {
            super(map);
        }

        public int zz(int z) {
            return 40 + z;
        }

        public int z(int z) {
            return 181 + z;
        }
    }

    public static class ZSpace {
        public int zzz(int z) {
            return 39 + z;
        }
    }

    public static class ZArithmetic
    extends JexlArithmetic {
        public ZArithmetic(boolean astrict) {
            super(astrict);
        }

        public int zzzz(int z) {
            return 38 + z;
        }
    }

    public static class ScriptContext
    extends MapContext
    implements JexlContext.NamespaceResolver {
        Map<String, Object> nsScript;

        ScriptContext(Map<String, Object> ns) {
            this.nsScript = ns;
        }

        public Object resolveNamespace(String name) {
            if (name == null) {
                return this;
            }
            if ("script".equals(name)) {
                return this.nsScript;
            }
            if ("functor".equals(name)) {
                return context -> {
                    HashMap<String, String> values = new HashMap<String, String>();
                    if ("gin".equals(context.get("base"))) {
                        values.put("drink", "gin fizz");
                    } else {
                        values.put("drink", "champaign");
                    }
                    return values;
                };
            }
            return null;
        }
    }

    public static class Edge {
        private Edge() {
        }

        public int exec(int arg) {
            return 1;
        }

        public int exec(int[] arg) {
            return 20;
        }

        public int exec(String arg) {
            return 2;
        }

        public int exec(String ... arg) {
            return 200;
        }

        public int exec(Object args) {
            return 3;
        }

        public int exec(Object ... args) {
            return 4;
        }

        public int exec(Boolean x, int arg) {
            return 1;
        }

        public int exec(Boolean x, int[] arg) {
            return 20;
        }

        public int exec(Boolean x, String arg) {
            return 2;
        }

        public int exec(Boolean x, Object args) {
            return 3;
        }

        public int exec(Boolean x, Object ... args) {
            return 4;
        }

        public Class<?>[] execute(Object ... args) {
            Class[] clazz = new Class[args.length];
            for (int a = 0; a < args.length; ++a) {
                clazz[a] = args[a] != null ? args[a].getClass() : Void.class;
            }
            return clazz;
        }
    }

    public static class MyMath {
        public double cos(double x) {
            return Math.cos(x);
        }
    }

    public static class FunctorOver
    extends Functor {
        public Object over(Object f, Object g) {
            return f + " + " + g;
        }
    }

    public static class Functor {
        private boolean overKill = false;
        private String under = null;

        void setKill(boolean ok) {
            this.overKill = ok;
        }

        public int ten() {
            return 10;
        }

        public int plus10(int num) {
            return num + 10;
        }

        public static int TWENTY() {
            return 20;
        }

        public static int PLUS20(int num) {
            return num + 20;
        }

        public static Class<?> NPEIfNull(Object x) {
            return x.getClass();
        }

        public Object over(String f, int i) {
            if (this.overKill) {
                throw new UnsupportedOperationException("kill " + f + " + " + i);
            }
            return f + " + " + i;
        }

        public Object over(String f, Date g) {
            return f + " + " + g;
        }

        public Object over(String f, String g) {
            return f + " + " + g;
        }

        public void setUnder(String str) {
            if (this.overKill) {
                throw new UnsupportedOperationException("kill " + str);
            }
            this.under = str;
        }

        public String getUnder() {
            if (this.overKill) {
                throw new UnsupportedOperationException("kill " + this.under);
            }
            return this.under;
        }
    }

    public static class ContextualFunctor {
        private final EnhancedContext context;

        public ContextualFunctor(EnhancedContext theContext) {
            this.context = theContext;
        }

        public int ratio(int n) {
            --this.context.factor;
            return n / this.context.factor;
        }
    }

    public static class EnhancedContext
    extends JexlEvalContext {
        int factor = 6;
        final Map<String, Object> funcs;

        EnhancedContext(Map<String, Object> funcs) {
            this.funcs = funcs;
        }

        @Override
        public Object resolveNamespace(String name) {
            return this.funcs.get(name);
        }
    }

    public static class VarArgs {
        public String callInts() {
            int result = -5000;
            return "Varargs:-5000";
        }

        public String callInts(Integer ... args) {
            int result = 0;
            if (args != null) {
                for (Integer arg : args) {
                    result += arg != null ? arg : -100;
                }
            } else {
                result = -1000;
            }
            return "Varargs:" + result;
        }

        public String callMixed(Integer fixed, Integer ... args) {
            int result = fixed;
            if (args != null) {
                for (Integer arg : args) {
                    result += arg != null ? arg : -100;
                }
            } else {
                result -= 1000;
            }
            return "Mixed:" + result;
        }

        public String callMixed(String mixed, Integer ... args) {
            int result = 0;
            if (args != null) {
                for (Integer arg : args) {
                    result += arg != null ? arg : -100;
                }
            } else {
                result = -1000;
            }
            return mixed + ":" + result;
        }

        public String concat(String ... strs) {
            if (strs.length <= 0) {
                return "";
            }
            StringBuilder strb = new StringBuilder(strs[0]);
            for (int s = 1; s < strs.length; ++s) {
                strb.append(", ");
                strb.append(strs[s]);
            }
            return strb.toString();
        }
    }
}

