/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jexl3.Foo;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class ForEachTest
extends JexlTestCase {
    public ForEachTest() {
        super("ForEachTest");
    }

    @Test
    public void testForEachWithEmptyStatement() throws Exception {
        JexlScript e = this.JEXL.createScript("for(item : list) ;");
        MapContext jc = new MapContext();
        jc.set("list", Collections.emptyList());
        Object o = e.execute((JexlContext)jc);
        Assert.assertNull((String)"Result is not null", (Object)o);
    }

    @Test
    public void testForEachWithEmptyList() throws Exception {
        JexlScript e = this.JEXL.createScript("for(item : list) 1+1");
        MapContext jc = new MapContext();
        jc.set("list", Collections.emptyList());
        Object o = e.execute((JexlContext)jc);
        Assert.assertNull((String)"Result is not null", (Object)o);
    }

    @Test
    public void testForEachWithArray() throws Exception {
        JexlScript e = this.JEXL.createScript("for(item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Object[]{"Hello", "World"});
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)"World", (Object)o);
    }

    @Test
    public void testForEachWithCollection() throws Exception {
        JexlScript e = this.JEXL.createScript("for(var item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", Arrays.asList("Hello", "World"));
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)"World", (Object)o);
    }

    @Test
    public void testForEachWithEnumeration() throws Exception {
        JexlScript e = this.JEXL.createScript("for(var item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new StringTokenizer("Hello,World", ","));
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)"World", (Object)o);
    }

    @Test
    public void testForEachWithIterator() throws Exception {
        JexlScript e = this.JEXL.createScript("for(var item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", Arrays.asList("Hello", "World").iterator());
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)"World", (Object)o);
    }

    @Test
    public void testForEachWithMap() throws Exception {
        JexlScript e = this.JEXL.createScript("for(item : list) item");
        MapContext jc = new MapContext();
        Properties map = System.getProperties();
        String lastProperty = (String)new ArrayList(map.values()).get(System.getProperties().size() - 1);
        jc.set("list", (Object)map);
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)lastProperty, (Object)o);
    }

    @Test
    public void testForEachWithBlock() throws Exception {
        JexlScript exs0 = this.JEXL.createScript("for(var in : list) { x = x + in; }");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Object[]{2, 3});
        jc.set("x", (Object)new Integer(1));
        Object o = exs0.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is wrong", (Object)new Integer(6), (Object)o);
        Assert.assertEquals((String)"x is wrong", (Object)new Integer(6), (Object)jc.get("x"));
    }

    @Test
    public void testForEachWithListExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("for(var item : list.keySet()) item");
        MapContext jc = new MapContext();
        Properties map = System.getProperties();
        String lastKey = (String)new ArrayList(map.keySet()).get(System.getProperties().size() - 1);
        jc.set("list", (Object)map);
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)lastKey, (Object)o);
    }

    @Test
    public void testForEachWithProperty() throws Exception {
        JexlScript e = this.JEXL.createScript("for(var item : list.cheeseList) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)"brie", (Object)o);
    }

    @Test
    public void testForEachWithIteratorMethod() throws Exception {
        JexlScript e = this.JEXL.createScript("for(var item : list.cheezy) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)"brie", (Object)o);
    }

    @Test
    public void testForEachBreakMethod() throws Exception {
        JexlScript e = this.JEXL.createScript("var rr = -1; for(var item : [1, 2, 3 ,4 ,5, 6]) { if (item == 3) { rr = item; break; }} rr");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)3, (Object)o);
    }

    @Test
    public void testForEachContinueMethod() throws Exception {
        JexlScript e = this.JEXL.createScript("var rr = 0; for(var item : [1, 2, 3 ,4 ,5, 6]) { if (item <= 3) continue; rr = rr + item;}");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not last evaluated expression", (Object)15, (Object)o);
    }

    @Test
    public void testForEachContinueBroken() throws Exception {
        try {
            JexlScript e = this.JEXL.createScript("var rr = 0; continue;");
            Assert.fail((String)"continue is out of loop!");
        }
        catch (JexlException.Parsing xparse) {
            String str = xparse.detailedMessage();
            Assert.assertTrue((boolean)str.contains("continue"));
        }
    }

    @Test
    public void testForEachBreakBroken() throws Exception {
        try {
            JexlScript e = this.JEXL.createScript("if (true) { break; }");
            Assert.fail((String)"break is out of loop!");
        }
        catch (JexlException.Parsing xparse) {
            String str = xparse.detailedMessage();
            Assert.assertTrue((boolean)str.contains("break"));
        }
    }
}

