/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.scripting;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import junit.framework.TestCase;
import org.apache.commons.jexl2.scripting.JexlScriptEngineFactory;

public class JexlScriptEngineTest
extends TestCase {
    private static final List<String> NAMES = Arrays.asList("JEXL", "Jexl", "jexl", "JEXL2", "Jexl2", "jexl2");
    private static final List<String> EXTENSIONS = Arrays.asList("jexl", "jexl2");
    private static final List<String> MIMES = Arrays.asList("application/x-jexl", "application/x-jexl2");

    public void testScriptEngineFactory() throws Exception {
        JexlScriptEngineFactory factory = new JexlScriptEngineFactory();
        JexlScriptEngineTest.assertEquals((Object)"JEXL Engine", (Object)factory.getParameter("javax.script.engine"));
        JexlScriptEngineTest.assertEquals((Object)"2.0", (Object)factory.getParameter("javax.script.engine_version"));
        JexlScriptEngineTest.assertEquals((Object)"JEXL", (Object)factory.getParameter("javax.script.language"));
        JexlScriptEngineTest.assertEquals((Object)"2.0", (Object)factory.getParameter("javax.script.language_version"));
        JexlScriptEngineTest.assertNull((Object)factory.getParameter("THREADING"));
        JexlScriptEngineTest.assertEquals(NAMES, (Object)factory.getParameter("javax.script.name"));
        JexlScriptEngineTest.assertEquals(EXTENSIONS, (Object)factory.getExtensions());
        JexlScriptEngineTest.assertEquals(MIMES, (Object)factory.getMimeTypes());
        JexlScriptEngineTest.assertEquals((String)"42;", (String)factory.getProgram(new String[]{"42"}));
        JexlScriptEngineTest.assertEquals((String)"str.substring(3,4)", (String)factory.getMethodCallSyntax("str", "substring", new String[]{"3", "4"}));
    }

    public void testScriptingGetBy() throws Exception {
        ScriptEngine engine;
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngineTest.assertNotNull((String)"Manager should not be null", (Object)manager);
        for (String name : NAMES) {
            engine = manager.getEngineByName(name);
            JexlScriptEngineTest.assertNotNull((String)"Engine should not be null (name)", (Object)engine);
        }
        for (String extension : EXTENSIONS) {
            engine = manager.getEngineByExtension(extension);
            JexlScriptEngineTest.assertNotNull((String)"Engine should not be null (extension)", (Object)engine);
        }
        for (String mime : MIMES) {
            engine = manager.getEngineByMimeType(mime);
            JexlScriptEngineTest.assertNotNull((String)"Engine should not be null (mime)", (Object)engine);
        }
    }

    public void testScripting() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngineTest.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("jexl2");
        Integer initialValue = 123;
        JexlScriptEngineTest.assertEquals((Object)initialValue, (Object)engine.eval("123"));
        JexlScriptEngineTest.assertEquals((Object)initialValue, (Object)engine.eval("0;123"));
        long time1 = System.currentTimeMillis();
        Long time2 = (Long)engine.eval("sys=context.class.forName(\"java.lang.System\");now=sys.currentTimeMillis();");
        JexlScriptEngineTest.assertTrue((String)"Must take some time to process this", (time1 <= time2 ? 1 : 0) != 0);
        engine.put("value", initialValue);
        JexlScriptEngineTest.assertEquals((Object)initialValue, (Object)engine.get("value"));
        Integer newValue = 124;
        JexlScriptEngineTest.assertEquals((Object)newValue, (Object)engine.eval("old=value;value=value+1"));
        JexlScriptEngineTest.assertEquals((Object)initialValue, (Object)engine.get("old"));
        JexlScriptEngineTest.assertEquals((Object)newValue, (Object)engine.get("value"));
        JexlScriptEngineTest.assertEquals((Object)engine.getContext(), (Object)engine.get("context"));
        JexlScriptEngineTest.assertEquals((Object)engine.getContext().getReader(), (Object)engine.eval("JEXL.in"));
        JexlScriptEngineTest.assertEquals((Object)engine.getContext().getWriter(), (Object)engine.eval("JEXL.out"));
        JexlScriptEngineTest.assertEquals((Object)engine.getContext().getErrorWriter(), (Object)engine.eval("JEXL.err"));
        JexlScriptEngineTest.assertEquals(System.class, (Object)engine.eval("JEXL.System"));
    }

    public void testNulls() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngineTest.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("jexl2");
        JexlScriptEngineTest.assertNotNull((String)"Engine should not be null (name)", (Object)engine);
        try {
            engine.eval((String)null);
            JexlScriptEngineTest.fail((String)"Should have caused NPE");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            engine.eval((Reader)null);
            JexlScriptEngineTest.fail((String)"Should have caused NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testScopes() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngineTest.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("JEXL");
        JexlScriptEngineTest.assertNotNull((String)"Engine should not be null (JEXL)", (Object)engine);
        manager.put("global", 1);
        engine.put("local", 10);
        manager.put("both", 7);
        engine.put("both", 7);
        engine.eval("local=local+1");
        engine.eval("global=global+1");
        engine.eval("both=both+1");
        engine.eval("newvar=42;");
        JexlScriptEngineTest.assertEquals((Object)2, (Object)manager.get("global"));
        JexlScriptEngineTest.assertEquals((Object)11, (Object)engine.get("local"));
        JexlScriptEngineTest.assertEquals((Object)7, (Object)manager.get("both"));
        JexlScriptEngineTest.assertEquals((Object)8, (Object)engine.get("both"));
        JexlScriptEngineTest.assertEquals((Object)42, (Object)engine.get("newvar"));
        JexlScriptEngineTest.assertNull((Object)manager.get("newvar"));
    }

    public void testDottedNames() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngineTest.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("JEXL");
        JexlScriptEngineTest.assertNotNull((String)"Engine should not be null (JEXL)", (Object)engine);
        engine.eval("this.is.a.test=null");
        JexlScriptEngineTest.assertNull((Object)engine.get("this.is.a.test"));
        JexlScriptEngineTest.assertEquals((Object)Boolean.TRUE, (Object)engine.eval("empty(this.is.a.test)"));
        Object mymap = engine.eval("testmap={ 'key1' : 'value1', 'key2' : 'value2' }");
        JexlScriptEngineTest.assertTrue((boolean)(mymap instanceof Map));
        JexlScriptEngineTest.assertEquals((int)2, (int)((Map)mymap).size());
    }
}

