/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.JpegImageData;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffHeader;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDirectory;

public class TiffReader
extends BinaryFileParser {
    private final boolean strict;
    private boolean bigTiff;
    private boolean standardTiff;
    private int entryMaxValueLength;

    public TiffReader(boolean strict) {
        this.strict = strict;
    }

    private JpegImageData getJpegRawImageData(ByteSource byteSource, TiffDirectory directory) throws ImagingException, IOException {
        TiffDirectory.ImageDataElement element = directory.getJpegRawImageDataElement();
        long offset = element.offset;
        int length = element.length;
        if (offset + (long)length > byteSource.size()) {
            length = (int)(byteSource.size() - offset);
        }
        byte[] data = byteSource.getByteArray(offset, length);
        if (this.strict && (length < 2 || ((data[data.length - 2] & 0xFF) << 8 | data[data.length - 1] & 0xFF) != 65497)) {
            throw new ImagingException("JPEG EOI marker could not be found at expected location");
        }
        return new JpegImageData(offset, length, data);
    }

    private ByteOrder getTiffByteOrder(int byteOrderByte) throws ImagingException {
        if (byteOrderByte == 73) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        if (byteOrderByte == 77) {
            return ByteOrder.BIG_ENDIAN;
        }
        throw new ImagingException("Invalid TIFF byte order " + (0xFF & byteOrderByte));
    }

    private AbstractTiffImageData getTiffRawImageData(ByteSource byteSource, TiffDirectory directory) throws ImagingException, IOException {
        List<TiffDirectory.ImageDataElement> elements = directory.getTiffRawImageDataElements();
        AbstractTiffElement.DataElement[] data = new AbstractTiffImageData.Data[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            TiffDirectory.ImageDataElement element = elements.get(i);
            byte[] bytes = byteSource.getByteArray(element.offset, element.length);
            data[i] = new AbstractTiffImageData.Data(element.offset, element.length, bytes);
        }
        if (directory.imageDataInStrips()) {
            TiffField rowsPerStripField = directory.findField(TiffTagConstants.TIFF_TAG_ROWS_PER_STRIP);
            int rowsPerStrip = Integer.MAX_VALUE;
            if (null != rowsPerStripField) {
                rowsPerStrip = rowsPerStripField.getIntValue();
            } else {
                TiffField imageHeight = directory.findField(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH);
                if (imageHeight != null) {
                    rowsPerStrip = imageHeight.getIntValue();
                }
            }
            return new AbstractTiffImageData.Strips(data, rowsPerStrip);
        }
        TiffField tileWidthField = directory.findField(TiffTagConstants.TIFF_TAG_TILE_WIDTH);
        if (null == tileWidthField) {
            throw new ImagingException("Can't find tile width field.");
        }
        int tileWidth = tileWidthField.getIntValue();
        TiffField tileLengthField = directory.findField(TiffTagConstants.TIFF_TAG_TILE_LENGTH);
        if (null == tileLengthField) {
            throw new ImagingException("Can't find tile length field.");
        }
        int tileLength = tileLengthField.getIntValue();
        return new AbstractTiffImageData.Tiles(data, tileWidth, tileLength);
    }

    public void read(ByteSource byteSource, FormatCompliance formatCompliance, Listener listener) throws ImagingException, IOException {
        this.readDirectories(byteSource, formatCompliance, listener);
    }

    public TiffContents readContents(ByteSource byteSource, TiffImagingParameters params, FormatCompliance formatCompliance) throws ImagingException, IOException {
        Collector collector = new Collector(params);
        this.read(byteSource, formatCompliance, collector);
        return collector.getContents();
    }

    public TiffContents readDirectories(ByteSource byteSource, boolean readImageData, FormatCompliance formatCompliance) throws ImagingException, IOException {
        TiffImagingParameters params = new TiffImagingParameters();
        params.setReadThumbnails(readImageData);
        Collector collector = new Collector(params);
        this.readDirectories(byteSource, formatCompliance, collector);
        TiffContents contents = collector.getContents();
        if (contents.directories.isEmpty()) {
            throw new ImagingException("Image did not contain any directories.");
        }
        return contents;
    }

    private void readDirectories(ByteSource byteSource, FormatCompliance formatCompliance, Listener listener) throws ImagingException, IOException {
        TiffHeader tiffHeader = this.readTiffHeader(byteSource);
        if (!listener.setTiffHeader(tiffHeader)) {
            return;
        }
        long offset = tiffHeader.offsetToFirstIFD;
        boolean dirType = false;
        ArrayList<Number> visited = new ArrayList<Number>();
        this.readDirectory(byteSource, offset, 0, formatCompliance, listener, visited);
    }

    private boolean readDirectory(ByteSource byteSource, long directoryOffset, int dirType, FormatCompliance formatCompliance, Listener listener, boolean ignoreNextDirectory, List<Number> visited) throws ImagingException, IOException {
        if (visited.contains(directoryOffset)) {
            return false;
        }
        visited.add(directoryOffset);
        try (InputStream is = byteSource.getInputStream();){
            long entryCount;
            if (directoryOffset >= byteSource.size()) {
                boolean bl = true;
                return bl;
            }
            BinaryFunctions.skipBytes(is, directoryOffset);
            ArrayList<TiffField> fields = new ArrayList<TiffField>();
            try {
                entryCount = this.standardTiff ? (long)BinaryFunctions.read2Bytes("DirectoryEntryCount", is, "Not a Valid TIFF File", this.getByteOrder()) : BinaryFunctions.read8Bytes("DirectoryEntryCount", is, "Not a Valid TIFF File", this.getByteOrder());
            }
            catch (IOException e) {
                if (this.strict) {
                    throw e;
                }
                boolean bl = true;
                if (is != null) {
                    is.close();
                }
                return bl;
            }
            int i = 0;
            while ((long)i < entryCount) {
                block32: {
                    byte[] value;
                    AbstractFieldType abstractFieldType;
                    long offset;
                    long count;
                    int tag;
                    block36: {
                        byte[] offsetBytes;
                        block34: {
                            long valueLength;
                            block35: {
                                tag = BinaryFunctions.read2Bytes("Tag", is, "Not a Valid TIFF File", this.getByteOrder());
                                int type = BinaryFunctions.read2Bytes("Type", is, "Not a Valid TIFF File", this.getByteOrder());
                                if (this.standardTiff) {
                                    count = 0xFFFFFFFFL & (long)BinaryFunctions.read4Bytes("Count", is, "Not a Valid TIFF File", this.getByteOrder());
                                    offsetBytes = BinaryFunctions.readBytes("Offset", is, 4, "Not a Valid TIFF File");
                                    offset = 0xFFFFFFFFL & (long)ByteConversions.toInt(offsetBytes, this.getByteOrder());
                                } else {
                                    count = BinaryFunctions.read8Bytes("Count", is, "Not a Valid TIFF File", this.getByteOrder());
                                    offsetBytes = BinaryFunctions.readBytes("Offset", is, 8, "Not a Valid TIFF File");
                                    offset = ByteConversions.toLong(offsetBytes, this.getByteOrder());
                                }
                                if (tag == 0) break block32;
                                try {
                                    abstractFieldType = AbstractFieldType.getFieldType(type);
                                }
                                catch (ImagingException imageReadEx) {
                                    break block32;
                                }
                                valueLength = count * (long)abstractFieldType.getSize();
                                if (valueLength <= (long)this.entryMaxValueLength) break block34;
                                if (offset >= 0L && offset + valueLength <= byteSource.size()) break block35;
                                if (this.strict) {
                                    throw new IOException("Attempt to read byte range starting from " + offset + " of length " + valueLength + " which is outside the file's size of " + byteSource.size());
                                }
                                break block32;
                            }
                            value = byteSource.getByteArray(offset, (int)valueLength);
                            break block36;
                        }
                        value = offsetBytes;
                    }
                    TiffField field = new TiffField(tag, dirType, abstractFieldType, count, offset, value, this.getByteOrder(), i);
                    fields.add(field);
                    if (!listener.addField(field)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                ++i;
            }
            long nextDirectoryOffset = 0xFFFFFFFFL & (long)BinaryFunctions.read4Bytes("nextDirectoryOffset", is, "Not a Valid TIFF File", this.getByteOrder());
            TiffDirectory directory = new TiffDirectory(dirType, fields, directoryOffset, nextDirectoryOffset, this.getByteOrder());
            if (listener.readImageData()) {
                if (directory.hasTiffImageData()) {
                    AbstractTiffImageData rawImageData = this.getTiffRawImageData(byteSource, directory);
                    directory.setTiffImageData(rawImageData);
                }
                if (directory.hasJpegImageData()) {
                    JpegImageData rawJpegImageData = this.getJpegRawImageData(byteSource, directory);
                    directory.setJpegImageData(rawJpegImageData);
                }
            }
            if (!listener.addDirectory(directory)) {
                boolean rawJpegImageData = true;
                return rawJpegImageData;
            }
            if (listener.readOffsetDirectories()) {
                TagInfoDirectory[] offsetFields = new TagInfoDirectory[]{ExifTagConstants.EXIF_TAG_EXIF_OFFSET, ExifTagConstants.EXIF_TAG_GPSINFO, ExifTagConstants.EXIF_TAG_INTEROP_OFFSET};
                int[] directoryTypes = new int[]{-2, -3, -4};
                for (int i2 = 0; i2 < offsetFields.length; ++i2) {
                    boolean subDirectoryRead;
                    TiffField field;
                    block33: {
                        TagInfoDirectory offsetField = offsetFields[i2];
                        field = directory.findField(offsetField);
                        if (field == null) continue;
                        subDirectoryRead = false;
                        try {
                            long subDirectoryOffset = directory.getFieldValue(offsetField);
                            int subDirectoryType = directoryTypes[i2];
                            subDirectoryRead = this.readDirectory(byteSource, subDirectoryOffset, subDirectoryType, formatCompliance, listener, true, visited);
                        }
                        catch (ImagingException imageReadException) {
                            if (!this.strict) break block33;
                            throw imageReadException;
                        }
                    }
                    if (subDirectoryRead) continue;
                    fields.remove(field);
                }
            }
            if (!ignoreNextDirectory && directory.getNextDirectoryOffset() > 0L) {
                this.readDirectory(byteSource, directory.getNextDirectoryOffset(), dirType + 1, formatCompliance, listener, visited);
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean readDirectory(ByteSource byteSource, long offset, int dirType, FormatCompliance formatCompliance, Listener listener, List<Number> visited) throws ImagingException, IOException {
        boolean ignoreNextDirectory = false;
        return this.readDirectory(byteSource, offset, dirType, formatCompliance, listener, false, visited);
    }

    public TiffContents readFirstDirectory(ByteSource byteSource, boolean readImageData, FormatCompliance formatCompliance) throws ImagingException, IOException {
        FirstDirectoryCollector collector = new FirstDirectoryCollector(readImageData);
        this.read(byteSource, formatCompliance, collector);
        TiffContents contents = collector.getContents();
        if (contents.directories.isEmpty()) {
            throw new ImagingException("Image did not contain any directories.");
        }
        return contents;
    }

    private TiffHeader readTiffHeader(ByteSource byteSource) throws ImagingException, IOException {
        try (InputStream is = byteSource.getInputStream();){
            TiffHeader tiffHeader = this.readTiffHeader(is);
            return tiffHeader;
        }
    }

    private TiffHeader readTiffHeader(InputStream is) throws ImagingException, IOException {
        long offsetToFirstIFD;
        byte byteOrder2;
        byte byteOrder1 = BinaryFunctions.readByte("BYTE_ORDER_1", is, "Not a Valid TIFF File");
        if (byteOrder1 != (byteOrder2 = BinaryFunctions.readByte("BYTE_ORDER_2", is, "Not a Valid TIFF File"))) {
            throw new ImagingException("Byte Order bytes don't match (" + byteOrder1 + ", " + byteOrder2 + ").");
        }
        ByteOrder byteOrder = this.getTiffByteOrder(byteOrder1);
        this.setByteOrder(byteOrder);
        int tiffVersion = BinaryFunctions.read2Bytes("tiffVersion", is, "Not a Valid TIFF File", this.getByteOrder());
        if (tiffVersion == 42) {
            this.bigTiff = false;
            this.standardTiff = true;
            this.entryMaxValueLength = 4;
            offsetToFirstIFD = 0xFFFFFFFFL & (long)BinaryFunctions.read4Bytes("offsetToFirstIFD", is, "Not a Valid TIFF File", this.getByteOrder());
        } else if (tiffVersion == 43) {
            this.bigTiff = true;
            this.standardTiff = false;
            this.entryMaxValueLength = 8;
            int byteSize = BinaryFunctions.read2Bytes("bytesizeOfOffset", is, "Not a Valid TIFF File", this.getByteOrder());
            int expectedZero = BinaryFunctions.read2Bytes("expectedZero", is, "Not a Valid TIFF File", this.getByteOrder());
            if (byteSize != 8 || expectedZero != 0) {
                throw new ImagingException("Misformed Big-TIFF header: " + tiffVersion);
            }
            offsetToFirstIFD = BinaryFunctions.read8Bytes("offsetToFirstIFD", is, "Not a Valid TIFF File", this.getByteOrder());
        } else {
            throw new ImagingException("Unknown TIFF Version: " + tiffVersion);
        }
        BinaryFunctions.skipBytes(is, offsetToFirstIFD - 8L, "Not a Valid TIFF File: couldn't find IFDs");
        return new TiffHeader(byteOrder, tiffVersion, offsetToFirstIFD, this.bigTiff);
    }

    public static interface Listener {
        public boolean addDirectory(TiffDirectory var1);

        public boolean addField(TiffField var1);

        public boolean readImageData();

        public boolean readOffsetDirectories();

        public boolean setTiffHeader(TiffHeader var1);
    }

    private static class Collector
    implements Listener {
        private TiffHeader tiffHeader;
        private final List<TiffDirectory> directories = new ArrayList<TiffDirectory>();
        private final List<TiffField> fields = new ArrayList<TiffField>();
        private final boolean readThumbnails;

        Collector() {
            this(new TiffImagingParameters());
        }

        Collector(TiffImagingParameters params) {
            this.readThumbnails = params.isReadThumbnails();
        }

        @Override
        public boolean addDirectory(TiffDirectory directory) {
            this.directories.add(directory);
            return true;
        }

        @Override
        public boolean addField(TiffField field) {
            this.fields.add(field);
            return true;
        }

        public TiffContents getContents() {
            return new TiffContents(this.tiffHeader, this.directories, this.fields);
        }

        @Override
        public boolean readImageData() {
            return this.readThumbnails;
        }

        @Override
        public boolean readOffsetDirectories() {
            return true;
        }

        @Override
        public boolean setTiffHeader(TiffHeader tiffHeader) {
            this.tiffHeader = tiffHeader;
            return true;
        }
    }

    private static final class FirstDirectoryCollector
    extends Collector {
        private final boolean readImageData;

        FirstDirectoryCollector(boolean readImageData) {
            this.readImageData = readImageData;
        }

        @Override
        public boolean addDirectory(TiffDirectory directory) {
            super.addDirectory(directory);
            return false;
        }

        @Override
        public boolean readImageData() {
            return this.readImageData;
        }
    }
}

