/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.wrappers;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbutils.ProxyFactory;

public class SqlNullCheckedResultSet
implements InvocationHandler {
    private static final Map<String, Method> NULL_METHODS;
    private static final String GET_NULL_PREFIX = "getNull";
    private static final ProxyFactory factory;
    private InputStream nullAsciiStream;
    private BigDecimal nullBigDecimal;
    private InputStream nullBinaryStream;
    private Blob nullBlob;
    private boolean nullBoolean;
    private byte nullByte;
    private byte[] nullBytes;
    private Reader nullCharacterStream;
    private Clob nullClob;
    private Date nullDate;
    private double nullDouble;
    private float nullFloat;
    private int nullInt;
    private long nullLong;
    private Object nullObject;
    private Ref nullRef;
    private short nullShort;
    private String nullString;
    private Time nullTime;
    private Timestamp nullTimestamp;
    private URL nullURL;
    private final ResultSet resultSet;

    public static ResultSet wrap(ResultSet resultSet) {
        return factory.createResultSet(new SqlNullCheckedResultSet(resultSet));
    }

    public SqlNullCheckedResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public InputStream getNullAsciiStream() {
        return this.nullAsciiStream;
    }

    public BigDecimal getNullBigDecimal() {
        return this.nullBigDecimal;
    }

    public InputStream getNullBinaryStream() {
        return this.nullBinaryStream;
    }

    public Blob getNullBlob() {
        return this.nullBlob;
    }

    public boolean getNullBoolean() {
        return this.nullBoolean;
    }

    public byte getNullByte() {
        return this.nullByte;
    }

    public byte[] getNullBytes() {
        if (this.nullBytes == null) {
            return null;
        }
        return (byte[])this.nullBytes.clone();
    }

    public Reader getNullCharacterStream() {
        return this.nullCharacterStream;
    }

    public Clob getNullClob() {
        return this.nullClob;
    }

    public Date getNullDate() {
        return this.nullDate != null ? new Date(this.nullDate.getTime()) : null;
    }

    public double getNullDouble() {
        return this.nullDouble;
    }

    public float getNullFloat() {
        return this.nullFloat;
    }

    public int getNullInt() {
        return this.nullInt;
    }

    public long getNullLong() {
        return this.nullLong;
    }

    public Object getNullObject() {
        return this.nullObject;
    }

    public Ref getNullRef() {
        return this.nullRef;
    }

    public short getNullShort() {
        return this.nullShort;
    }

    public String getNullString() {
        return this.nullString;
    }

    public Time getNullTime() {
        return this.nullTime != null ? new Time(this.nullTime.getTime()) : null;
    }

    public Timestamp getNullTimestamp() {
        if (this.nullTimestamp == null) {
            return null;
        }
        Timestamp ts = new Timestamp(this.nullTimestamp.getTime());
        ts.setNanos(this.nullTimestamp.getNanos());
        return ts;
    }

    public URL getNullURL() {
        return this.nullURL;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke((Object)this.resultSet, args);
        Method nullMethod = NULL_METHODS.get(method.getName());
        return nullMethod != null && this.resultSet.wasNull() ? nullMethod.invoke((Object)this, (Object[])null) : result;
    }

    public void setNullAsciiStream(InputStream nullAsciiStream) {
        this.nullAsciiStream = nullAsciiStream;
    }

    public void setNullBigDecimal(BigDecimal nullBigDecimal) {
        this.nullBigDecimal = nullBigDecimal;
    }

    public void setNullBinaryStream(InputStream nullBinaryStream) {
        this.nullBinaryStream = nullBinaryStream;
    }

    public void setNullBlob(Blob nullBlob) {
        this.nullBlob = nullBlob;
    }

    public void setNullBoolean(boolean nullBoolean) {
        this.nullBoolean = nullBoolean;
    }

    public void setNullByte(byte nullByte) {
        this.nullByte = nullByte;
    }

    public void setNullBytes(byte[] nullBytes) {
        this.nullBytes = (byte[])(nullBytes != null ? (byte[])nullBytes.clone() : null);
    }

    public void setNullCharacterStream(Reader nullCharacterStream) {
        this.nullCharacterStream = nullCharacterStream;
    }

    public void setNullClob(Clob nullClob) {
        this.nullClob = nullClob;
    }

    public void setNullDate(Date nullDate) {
        this.nullDate = nullDate != null ? new Date(nullDate.getTime()) : null;
    }

    public void setNullDouble(double nullDouble) {
        this.nullDouble = nullDouble;
    }

    public void setNullFloat(float nullFloat) {
        this.nullFloat = nullFloat;
    }

    public void setNullInt(int nullInt) {
        this.nullInt = nullInt;
    }

    public void setNullLong(long nullLong) {
        this.nullLong = nullLong;
    }

    public void setNullObject(Object nullObject) {
        this.nullObject = nullObject;
    }

    public void setNullRef(Ref nullRef) {
        this.nullRef = nullRef;
    }

    public void setNullShort(short nullShort) {
        this.nullShort = nullShort;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public void setNullTime(Time nullTime) {
        this.nullTime = nullTime != null ? new Time(nullTime.getTime()) : null;
    }

    public void setNullTimestamp(Timestamp nullTimestamp) {
        if (nullTimestamp != null) {
            this.nullTimestamp = new Timestamp(nullTimestamp.getTime());
            this.nullTimestamp.setNanos(nullTimestamp.getNanos());
        } else {
            this.nullTimestamp = null;
        }
    }

    public void setNullURL(URL nullURL) {
        this.nullURL = nullURL;
    }

    static {
        Method[] methods;
        NULL_METHODS = new HashMap<String, Method>();
        for (Method method : methods = SqlNullCheckedResultSet.class.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith(GET_NULL_PREFIX)) continue;
            String normalName = "get" + methodName.substring(GET_NULL_PREFIX.length());
            NULL_METHODS.put(normalName, method);
        }
        factory = ProxyFactory.instance();
    }
}

