/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodeIteratorAttribute;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationIteratorAttributes
extends AbstractXPathTest {
    private static final String TEST_ATTR = "test";
    NodePointer pointer;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ConfigurationNode testNode = this.root.getChild(1);
        testNode.addAttribute((ConfigurationNode)new DefaultConfigurationNode(TEST_ATTR, (Object)"yes"));
        this.pointer = new ConfigurationNodePointer(testNode, Locale.getDefault());
    }

    @Test
    public void testIterateAllAttributes() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, "*"));
        Assert.assertEquals((String)"Wrong number of attributes", (long)2L, (long)this.iteratorSize((NodeIterator)it));
        List<ConfigurationNode> attrs = this.iterationElements((NodeIterator)it);
        Assert.assertEquals((String)"Wrong first attribute", (Object)"counter", (Object)attrs.get(0).getName());
        Assert.assertEquals((String)"Wrong first attribute", (Object)TEST_ATTR, (Object)attrs.get(1).getName());
    }

    @Test
    public void testIterateSpecificAttribute() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, TEST_ATTR));
        Assert.assertEquals((String)"Wrong number of attributes", (long)1L, (long)this.iteratorSize((NodeIterator)it));
        Assert.assertEquals((String)"Wrong attribute", (Object)TEST_ATTR, (Object)this.iterationElements((NodeIterator)it).get(0).getName());
    }

    @Test
    public void testIterateUnknownAttribute() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, "unknown"));
        Assert.assertEquals((String)"Found attributes", (long)0L, (long)this.iteratorSize((NodeIterator)it));
    }

    @Test
    public void testIterateNamespace() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(TEST_ATTR, "*"));
        Assert.assertEquals((String)"Found attributes", (long)0L, (long)this.iteratorSize((NodeIterator)it));
    }
}

