/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.resolver.CatalogResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.EntityResolver;

public class TestCatalogResolver {
    private static final String CATALOG_FILES = "catalog.xml";
    private static final String PUBLIC_FILE = "testResolver.xml";
    private static final String REWRITE_SYSTEM_FILE = "test.properties.xml";
    private static final String REWRITE_SCHEMA_FILE = "sample.xml";
    private CatalogResolver resolver;
    private XMLConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.resolver = new CatalogResolver();
        this.resolver.setCatalogFiles(CATALOG_FILES);
        this.config = new XMLConfiguration();
        this.config.setEntityResolver((EntityResolver)this.resolver);
    }

    @After
    public void tearDown() throws Exception {
        this.resolver = null;
        this.config = null;
    }

    @Test
    public void testPublic() throws Exception {
        this.config.setFileName(PUBLIC_FILE);
        this.config.load();
    }

    @Test
    public void testRewriteSystem() throws Exception {
        this.config.setFileName(REWRITE_SYSTEM_FILE);
        this.config.load();
    }

    @Test
    public void testSchemaResolver() throws Exception {
        this.config.setFileName(REWRITE_SCHEMA_FILE);
        this.config.setSchemaValidation(true);
        this.config.load();
    }

    @Test
    public void testDebug() throws Exception {
        this.resolver.setDebug(true);
    }

    @Test
    public void testLogger() throws Exception {
        Log log = LogFactory.getLog(this.getClass());
        this.resolver.setLogger(log);
        Assert.assertNotNull((String)"No Logger returned", (Object)this.resolver.getLogger());
        Assert.assertTrue((String)"Incorrect Logger", (log == this.resolver.getLogger() ? 1 : 0) != 0);
    }
}

