/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class IndexExtractorTest {
    @ParameterizedTest
    @ValueSource(ints={32, 33})
    void testAsIndexArray(int n) {
        IndexExtractor ip = i -> {
            for (int j = 0; j < n; ++j) {
                i.test(0);
            }
            return true;
        };
        Assertions.assertArrayEquals((int[])new int[n], (int[])ip.asIndexArray());
    }

    @Test
    public void testFromBitMapExtractor() {
        TestingBitMapExtractor testingBitMapExtractor = new TestingBitMapExtractor(new long[]{1L, 2L, 3L});
        IndexExtractor underTest = IndexExtractor.fromBitMapExtractor((BitMapExtractor)testingBitMapExtractor);
        ArrayList lst = new ArrayList();
        underTest.processIndices(lst::add);
        Assertions.assertEquals((int)4, (int)lst.size());
        Assertions.assertEquals((Integer)0, (Integer)((Integer)lst.get(0)));
        Assertions.assertEquals((Integer)65, (Integer)((Integer)lst.get(1)));
        Assertions.assertEquals((Integer)128, (Integer)((Integer)lst.get(2)));
        Assertions.assertEquals((Integer)129, (Integer)((Integer)lst.get(3)));
        testingBitMapExtractor = new TestingBitMapExtractor(new long[]{-1L});
        underTest = IndexExtractor.fromBitMapExtractor((BitMapExtractor)testingBitMapExtractor);
        lst = new ArrayList();
        underTest.processIndices(lst::add);
        Assertions.assertEquals((int)64, (int)lst.size());
        for (int i = 0; i < 64; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)((Integer)lst.get(i)));
        }
    }

    private static final class TestingBitMapExtractor
    implements BitMapExtractor {
        long[] values;

        TestingBitMapExtractor(long[] values) {
            this.values = values;
        }

        public boolean processBitMaps(LongPredicate consumer) {
            for (long l : this.values) {
                if (consumer.test(l)) continue;
                return false;
            }
            return true;
        }
    }
}

