/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPropertyValueEqualsPredicate<T, V>
implements Predicate<T> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String propertyName;
    private final V propertyValue;
    private final boolean ignoreNull;

    public BeanPropertyValueEqualsPredicate(String propertyName, V propertyValue) {
        this(propertyName, propertyValue, false);
    }

    public BeanPropertyValueEqualsPredicate(String propertyName, V propertyValue, boolean ignoreNull) {
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.ignoreNull = ignoreNull;
    }

    protected boolean evaluateValue(V expected, Object actual) {
        return Objects.equals(expected, actual);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public V getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    @Override
    public boolean test(T object) {
        boolean evaluation = false;
        try {
            evaluation = this.evaluateValue(this.propertyValue, PropertyUtils.getProperty(object, this.propertyName));
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Problem during evaluation. Null value encountered in property path...";
            if (!this.ignoreNull) {
                throw new IllegalArgumentException("Problem during evaluation. Null value encountered in property path...", e);
            }
            this.log.warn((Object)"Problem during evaluation. Null value encountered in property path...", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access the property provided.";
            throw new IllegalArgumentException("Unable to access the property provided.", e);
        }
        catch (InvocationTargetException e) {
            String errorMsg = "Exception occurred in property's getter";
            throw new IllegalArgumentException("Exception occurred in property's getter", e);
        }
        catch (NoSuchMethodException e) {
            String errorMsg = "Property not found.";
            throw new IllegalArgumentException("Property not found.", e);
        }
        return evaluation;
    }
}

