/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.query;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.query.QueryTypeDialog;
import org.apache.cayenne.modeler.dialog.query.QueryTypeModel;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateQueryUndoableEdit;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.Query;
import org.scopemvc.controller.basic.BasicController;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;
import org.scopemvc.core.View;

public class QueryTypeController
extends BasicController {
    public static final String CANCEL_CONTROL = "cayenne.modeler.queryType.cancel.button";
    public static final String CREATE_CONTROL = "cayenne.modeler.queryType.create.button";
    public static final String OBJECT_QUERY_CONTROL = "cayenne.modeler.queryType.selectQuery.radio";
    public static final String SQL_QUERY_CONTROL = "cayenne.modeler.queryType.sqlQuery.radio";
    public static final String PROCEDURE_QUERY_CONTROL = "cayenne.modeler.queryType.procedureQuery.radio";
    public static final String EJBQL_QUERY_CONTROL = "cayenne.modeler.queryType.ejbqlQuery.radio";
    protected ProjectController mediator;
    protected DataMap dataMap;
    protected DataDomain domain;
    protected Query query;

    public QueryTypeController(ProjectController mediator) {
        this.mediator = mediator;
        this.dataMap = mediator.getCurrentDataMap();
        this.domain = mediator.getCurrentDataDomain();
    }

    protected void doHandleControl(Control control) throws ControlException {
        if (control.matchesID(CANCEL_CONTROL)) {
            this.shutdown();
        } else if (control.matchesID(CREATE_CONTROL)) {
            this.createQuery();
        } else if (control.matchesID(OBJECT_QUERY_CONTROL) || control.matchesID(SQL_QUERY_CONTROL) || control.matchesID(PROCEDURE_QUERY_CONTROL) || control.matchesID(EJBQL_QUERY_CONTROL)) {
            // empty if block
        }
    }

    public void startup() {
        this.setModel(new QueryTypeModel(this.mediator.getCurrentDataMap()));
        this.setView((View)new QueryTypeDialog());
        this.showView();
    }

    public void createQuery() {
        QueryTypeModel model = (QueryTypeModel)this.getModel();
        Query query = model.getSelectedQuery();
        if (query == null) {
            return;
        }
        String queryName = NamedObjectFactory.createName(Query.class, (Object)this.dataMap);
        if (query instanceof EJBQLQuery) {
            ((EJBQLQuery)query).setName(queryName);
        } else {
            ((AbstractQuery)query).setName(queryName);
        }
        this.dataMap.addQuery(query);
        this.mediator.getApplication().getUndoManager().addEdit(new CreateQueryUndoableEdit(this.domain, this.dataMap, query));
        QueryTypeController.fireQueryEvent((Object)this, this.mediator, this.domain, this.dataMap, query);
        this.shutdown();
    }

    public static void fireQueryEvent(Object src, ProjectController mediator, DataDomain domain, DataMap dataMap, Query query) {
        mediator.fireQueryEvent(new QueryEvent(src, query, 2, dataMap));
        mediator.fireQueryDisplayEvent(new QueryDisplayEvent(src, query, dataMap, domain));
    }
}

