/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.FileClassLoadingService;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.HSQLEmbeddedPreferenceEditor;
import org.apache.cayenne.pref.HSQLEmbeddedPreferenceService;
import org.apache.cayenne.pref.PreferenceDetail;

public class CayenneModelerPreferenceEditor
extends HSQLEmbeddedPreferenceEditor {
    protected boolean refreshingClassLoader;
    protected Application application;

    public CayenneModelerPreferenceEditor(Application application) {
        super((HSQLEmbeddedPreferenceService)application.getPreferenceService());
        this.application = application;
    }

    public boolean isRefreshingClassLoader() {
        return this.refreshingClassLoader;
    }

    public void setRefreshingClassLoader(boolean refreshingClassLoader) {
        this.refreshingClassLoader = refreshingClassLoader;
    }

    public void save() {
        super.save();
        if (this.isRefreshingClassLoader()) {
            this.application.initClassLoader();
            this.refreshingClassLoader = false;
        }
    }

    public PreferenceDetail createDetail(Domain domain, String key) {
        this.changeInDomain(domain);
        return super.createDetail(domain, key);
    }

    public PreferenceDetail deleteDetail(Domain domain, String key) {
        this.changeInDomain(domain);
        return super.deleteDetail(domain, key);
    }

    protected void changeInDomain(Domain domain) {
        if (!this.refreshingClassLoader && domain != null && FileClassLoadingService.class.getName().equals(domain.getName())) {
            this.refreshingClassLoader = true;
        }
    }
}

