/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;

class DataDomainLegacyQueryAction
implements QueryRouter,
OperationObserver {
    static final boolean DONE = true;
    DataDomain domain;
    OperationObserver callback;
    Query query;
    QueryMetadata metadata;
    Map<QueryEngine, List<Query>> queriesByNode;
    Map<Query, Query> queriesByExecutedQueries;

    DataDomainLegacyQueryAction(DataDomain domain, Query query, OperationObserver callback) {
        this.domain = domain;
        this.query = query;
        this.metadata = query.getMetaData(domain.getEntityResolver());
        this.callback = callback;
    }

    final void execute() {
        this.queriesByNode = null;
        this.queriesByExecutedQueries = null;
        this.query.route(this, this.domain.getEntityResolver(), null);
        if (this.queriesByNode != null) {
            for (Map.Entry<QueryEngine, List<Query>> entry : this.queriesByNode.entrySet()) {
                QueryEngine nextNode = entry.getKey();
                Collection nodeQueries = entry.getValue();
                nextNode.performQueries(nodeQueries, this);
            }
        }
    }

    @Override
    public void route(QueryEngine engine, Query query, Query substitutedQuery) {
        List<Query> queries = null;
        if (this.queriesByNode == null) {
            this.queriesByNode = new HashMap<QueryEngine, List<Query>>();
        } else {
            queries = this.queriesByNode.get(engine);
        }
        if (queries == null) {
            queries = new ArrayList<Query>(5);
            this.queriesByNode.put(engine, queries);
        }
        queries.add(query);
        if (substitutedQuery != null && substitutedQuery != query) {
            if (this.queriesByExecutedQueries == null) {
                this.queriesByExecutedQueries = new HashMap<Query, Query>();
            }
            this.queriesByExecutedQueries.put(query, substitutedQuery);
        }
    }

    @Override
    public QueryEngine engineForDataMap(DataMap map) {
        if (map == null) {
            throw new NullPointerException("Null DataMap, can't determine DataNode.");
        }
        DataNode node = this.domain.lookupDataNode(map);
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode exists for DataMap %s", map);
        }
        return node;
    }

    @Override
    public QueryEngine engineForName(String name) {
        DataNode node;
        if (name != null) {
            node = this.domain.getDataNode(name);
            if (node == null) {
                throw new CayenneRuntimeException("No DataNode exists for name %s", name);
            }
        } else {
            node = this.domain.getDefaultNode();
            if (node == null) {
                throw new CayenneRuntimeException("No default DataNode exists.", new Object[0]);
            }
        }
        return node;
    }

    @Override
    public void nextCount(Query query, int resultCount) {
        this.callback.nextCount(this.queryForExecutedQuery(query), resultCount);
    }

    @Override
    public void nextBatchCount(Query query, int[] resultCount) {
        this.callback.nextBatchCount(this.queryForExecutedQuery(query), resultCount);
    }

    @Override
    public void nextRows(Query query, List<?> dataRows) {
        this.callback.nextRows(this.queryForExecutedQuery(query), dataRows);
    }

    public void nextRows(Query q, ResultIterator it) {
        this.callback.nextRows(this.queryForExecutedQuery(q), it);
    }

    public void nextGeneratedRows(Query query, ResultIterator keys, ObjectId idToUpdate) {
        this.callback.nextGeneratedRows(this.queryForExecutedQuery(query), keys, idToUpdate);
    }

    @Override
    public void nextQueryException(Query query, Exception ex) {
        this.callback.nextQueryException(this.queryForExecutedQuery(query), ex);
    }

    @Override
    public void nextGlobalException(Exception e) {
        this.callback.nextGlobalException(e);
    }

    @Override
    public boolean isIteratedResult() {
        return this.callback.isIteratedResult();
    }

    Query queryForExecutedQuery(Query executedQuery) {
        Query q = null;
        if (this.queriesByExecutedQueries != null) {
            q = this.queriesByExecutedQueries.get(executedQuery);
        }
        return q != null ? q : executedQuery;
    }
}

