/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.s3.domain.AutoValue_ListMultipartUploadResponse;

@Beta
public abstract class ListMultipartUploadResponse {
    public abstract int partNumber();

    @Nullable
    public abstract Date lastModified();

    public abstract String eTag();

    public abstract long size();

    public static ListMultipartUploadResponse create(int partNumber, @Nullable Date lastModified, String eTag, long size) {
        Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"partNumber must be greater than zero, was: %s", (int)partNumber);
        Preconditions.checkNotNull((Object)eTag, (Object)"eTag");
        if (lastModified != null) {
            lastModified = (Date)lastModified.clone();
        }
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (String)"size must be positive, was: %s", (long)size);
        return new AutoValue_ListMultipartUploadResponse(partNumber, lastModified, eTag, size);
    }
}

