/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import com.hierynomus.sshj.common.KeyDecryptionFailedException;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyPair;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.pkcs.KeyPairConverter;
import net.schmizz.sshj.userauth.keyprovider.pkcs.PrivateKeyInfoKeyPairConverter;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS8KeyFile
extends BaseFileKeyProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected KeyPairConverter<PrivateKeyInfo> privateKeyInfoKeyPairConverter = new PrivateKeyInfoKeyPairConverter();

    @Override
    protected KeyPair readKeyPair() throws IOException {
        KeyPair kp = null;
        PEMParser r = null;
        while (true) {
            try {
                r = new PEMParser(this.resource.getReader());
                Object o = r.readObject();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                if (SecurityUtils.getSecurityProvider() != null) {
                    pemConverter.setProvider(SecurityUtils.getSecurityProvider());
                }
                if (o instanceof PEMEncryptedKeyPair) {
                    PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)o;
                    PEMKeyPair pemKeyPair = this.readEncryptedKeyPair(encryptedKeyPair);
                    kp = pemConverter.getKeyPair(pemKeyPair);
                    break;
                }
                if (o instanceof PEMKeyPair) {
                    kp = pemConverter.getKeyPair((PEMKeyPair)o);
                    break;
                }
                if (o instanceof PrivateKeyInfo) {
                    PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)o;
                    PEMKeyPair pemKeyPair = this.privateKeyInfoKeyPairConverter.getKeyPair(privateKeyInfo);
                    kp = pemConverter.getKeyPair(pemKeyPair);
                    break;
                }
                if (o instanceof PKCS8EncryptedPrivateKeyInfo) {
                    PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)o;
                    PrivateKeyInfo privateKeyInfo = this.readEncryptedPrivateKeyInfo(encryptedPrivateKeyInfo);
                    PEMKeyPair pemKeyPair = this.privateKeyInfoKeyPairConverter.getKeyPair(privateKeyInfo);
                    kp = pemConverter.getKeyPair(pemKeyPair);
                    break;
                }
                this.log.warn("Unexpected PKCS8 PEM Object [{}]", o);
            }
            catch (EncryptionException e) {
                block12: {
                    try {
                        if (this.pwdf == null || !this.pwdf.shouldRetry(this.resource)) break block12;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(new Closeable[]{r});
                        throw throwable;
                    }
                    IOUtils.closeQuietly(new Closeable[]{r});
                    continue;
                }
                throw new KeyDecryptionFailedException(e);
            }
            break;
        }
        IOUtils.closeQuietly(new Closeable[]{r});
        if (kp == null) {
            throw new IOException("Could not read key pair from: " + this.resource);
        }
        return kp;
    }

    public String toString() {
        return "PKCS8KeyFile{resource=" + this.resource + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PEMKeyPair readEncryptedKeyPair(PEMEncryptedKeyPair encryptedKeyPair) throws IOException {
        PEMKeyPair pEMKeyPair;
        JcePEMDecryptorProviderBuilder builder = new JcePEMDecryptorProviderBuilder();
        if (SecurityUtils.getSecurityProvider() != null) {
            builder.setProvider(SecurityUtils.getSecurityProvider());
        }
        char[] passphrase = null;
        try {
            passphrase = this.pwdf == null ? null : this.pwdf.reqPassword(this.resource);
            pEMKeyPair = encryptedKeyPair.decryptKeyPair(builder.build(passphrase));
        }
        catch (Throwable throwable) {
            PasswordUtils.blankOut(passphrase);
            throw throwable;
        }
        PasswordUtils.blankOut(passphrase);
        return pEMKeyPair;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrivateKeyInfo readEncryptedPrivateKeyInfo(PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) throws EncryptionException {
        PrivateKeyInfo privateKeyInfo;
        JceOpenSSLPKCS8DecryptorProviderBuilder builder = new JceOpenSSLPKCS8DecryptorProviderBuilder();
        if (SecurityUtils.getSecurityProvider() != null) {
            builder.setProvider(SecurityUtils.getSecurityProvider());
        }
        char[] passphrase = null;
        try {
            passphrase = this.pwdf == null ? null : this.pwdf.reqPassword(this.resource);
            InputDecryptorProvider inputDecryptorProvider = builder.build(passphrase);
            privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
        }
        catch (OperatorCreationException e) {
            try {
                throw new EncryptionException("Loading Password for Encrypted Private Key Failed", (Throwable)e);
                catch (PKCSException e2) {
                    throw new EncryptionException("Reading Encrypted Private Key Failed", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                PasswordUtils.blankOut(passphrase);
                throw throwable;
            }
        }
        PasswordUtils.blankOut(passphrase);
        return privateKeyInfo;
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PKCS8KeyFile();
        }

        @Override
        public String getName() {
            return "PKCS8";
        }
    }
}

