/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseEventTypesFromHttpResponse
implements Function<HttpResponse, Set<String>> {
    private final ParseFirstJsonValueNamed<Set<EventType>> parser;

    @Inject
    public ParseEventTypesFromHttpResponse(GsonWrapper gsonView) {
        this.parser = new ParseFirstJsonValueNamed((GsonWrapper)Preconditions.checkNotNull((Object)gsonView, (Object)"gsonView"), (TypeLiteral)new TypeLiteral<Set<EventType>>(){}, new String[]{"eventtype"});
    }

    public Set<String> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        Set toParse = (Set)this.parser.apply(response);
        Preconditions.checkNotNull((Object)toParse, (String)"parsed result from %s", (Object)response);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EventType entry : toParse) {
            builder.add((Object)entry.name);
        }
        return builder.build();
    }

    private static class EventType {
        private String name;

        private EventType() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventType that = (EventType)o;
            return Objects.equal((Object)this.name, (Object)that.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name});
        }
    }
}

