/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.digitalocean2.domain.options.ImageListOptions;
import org.jclouds.digitalocean2.functions.LinkToListOptions;
import org.jclouds.http.utils.Queries;

public class LinkToImageListOptions
implements Function<URI, ImageListOptions> {
    public ImageListOptions apply(URI input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null");
        Multimap queryParams = (Multimap)Queries.queryParser().apply((Object)input.getQuery());
        String nextPage = LinkToListOptions.getFirstOrNull("page", (Multimap<String, String>)queryParams);
        String nextPerPage = LinkToListOptions.getFirstOrNull("per_page", (Multimap<String, String>)queryParams);
        String nextType = LinkToListOptions.getFirstOrNull("type", (Multimap<String, String>)queryParams);
        String nextPrivate = LinkToListOptions.getFirstOrNull("private", (Multimap<String, String>)queryParams);
        ImageListOptions options = new ImageListOptions();
        if (nextPage != null) {
            options.page(Integer.parseInt(nextPage));
        }
        if (nextPerPage != null) {
            options.perPage(Integer.parseInt(nextPerPage));
        }
        if (nextType != null) {
            options.type(nextType);
        }
        if (nextPrivate != null) {
            options.privateImages(Boolean.parseBoolean(nextPrivate));
        }
        return options;
    }
}

