/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.ssh.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.task.system.internal.AbstractProcessTaskFactory;

public abstract class AbstractSshExecTaskFactory<T extends AbstractProcessTaskFactory<T, RET>, RET>
extends AbstractProcessTaskFactory<T, RET> {
    public AbstractSshExecTaskFactory(String ... commands) {
        super(commands);
    }

    public AbstractSshExecTaskFactory(MachineLocation machine, String ... commands) {
        this(commands);
        this.machine(machine);
    }

    protected abstract String taskTypeShortName();

    public ProcessTaskWrapper<RET> newTask() {
        this.dirty = false;
        return new ProcessTaskWrapper<RET>(this){
            protected Std2x2StreamProvider richStreamProvider;
            {
                this.richStreamProvider = null;
            }

            @Override
            protected void run(ConfigBag config) {
                Preconditions.checkNotNull((Object)this.getRemoteExecCapability(), (Object)"No remote exec capability or machine configured on task");
                this.exitCode = Boolean.FALSE.equals(this.runAsScript) ? this.getRemoteExecCapability().execCommands(config.getAllConfig(), this.getSummary(), this.getCommands(true), this.shellEnvironment) : this.getRemoteExecCapability().execScript(config.getAllConfig(), this.getSummary(), this.getCommands(true), this.shellEnvironment);
            }

            @Override
            protected String taskTypeShortName() {
                return AbstractSshExecTaskFactory.this.taskTypeShortName();
            }

            @Override
            protected void initStreams(TaskBuilder<Object> tb) {
                this.richStreamProvider = AbstractSshExecTaskFactory.this.getRichStreamProvider(tb);
                if (this.richStreamProvider == null) {
                    super.initStreams(tb);
                } else {
                    super.initStreams(this.richStreamProvider);
                }
            }

            @Override
            protected ByteArrayOutputStream stderrForReading() {
                if (this.richStreamProvider != null) {
                    return this.richStreamProvider.stderrForReading;
                }
                return super.stderrForReading();
            }

            @Override
            protected OutputStream stderrForWriting() {
                if (this.richStreamProvider != null) {
                    return this.richStreamProvider.stderrForWriting;
                }
                return super.stderrForWriting();
            }

            @Override
            protected ByteArrayOutputStream stdoutForReading() {
                if (this.richStreamProvider != null) {
                    return this.richStreamProvider.stdoutForReading;
                }
                return super.stdoutForReading();
            }

            @Override
            protected OutputStream stdoutForWriting() {
                if (this.richStreamProvider != null) {
                    return this.richStreamProvider.stdoutForWriting;
                }
                return super.stdoutForWriting();
            }
        };
    }

    protected Std2x2StreamProvider getRichStreamProvider(TaskBuilder<?> tb) {
        return null;
    }

    @Beta
    public static class Std2x2StreamProvider {
        public ByteArrayOutputStream stdoutForReading;
        public ByteArrayOutputStream stderrForReading;
        public OutputStream stdoutForWriting;
        public OutputStream stderrForWriting;

        public static Std2x2StreamProvider newDefault(TaskBuilder<?> tb) {
            Std2x2StreamProvider r = new Std2x2StreamProvider();
            r.stdoutForReading = new ByteArrayOutputStream();
            r.stdoutForWriting = r.stdoutForReading;
            r.stderrForReading = new ByteArrayOutputStream();
            r.stderrForWriting = r.stderrForReading;
            tb.tag(BrooklynTaskTags.tagForStreamSoft("stdout", r.stdoutForReading));
            tb.tag(BrooklynTaskTags.tagForStreamSoft("stderr", r.stderrForReading));
            return r;
        }
    }
}

