/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.base.Stopwatch;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensorInitializer;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticSensor<T>
extends AddSensorInitializer<T> {
    private static final Logger log = LoggerFactory.getLogger(StaticSensor.class);
    public static final ConfigKey<Object> STATIC_VALUE = ConfigKeys.newConfigKey(Object.class, "static.value");
    public static final ConfigKey<Duration> TIMEOUT = ConfigKeys.newConfigKey(Duration.class, "static.timeout", "Duration to wait for the value to resolve", Duration.PRACTICALLY_FOREVER);

    public StaticSensor() {
    }

    public StaticSensor(ConfigBag params) {
        super(params);
    }

    @Override
    public void apply(final EntityLocal entity) {
        final AttributeSensor sensor = this.addSensor(entity);
        class ResolveValue
        implements Callable<Maybe<T>> {
            ResolveValue() {
            }

            @Override
            public Maybe<T> call() throws Exception {
                return Tasks.resolving(StaticSensor.this.initParam(STATIC_VALUE)).as(sensor.getTypeToken()).timeout((Duration)StaticSensor.this.initParam(TIMEOUT)).getMaybe();
            }
        }
        final Task resolveValue = Tasks.builder().displayName("resolving " + this.initParam(STATIC_VALUE)).body(new ResolveValue()).build();
        class SetValue
        implements Callable<T> {
            SetValue() {
            }

            @Override
            public T call() throws Exception {
                Stopwatch sw = Stopwatch.createStarted();
                Maybe v = (Maybe)resolveValue.get();
                if (!v.isPresent()) {
                    Duration timeout = (Duration)StaticSensor.this.initParam(TIMEOUT);
                    if (timeout == null || Duration.of((Object)sw.elapsed()).isShorterThan(timeout)) {
                        log.warn(this + " not setting sensor " + sensor + " on " + entity + "; cannot resolve " + StaticSensor.this.initParam(STATIC_VALUE) + ": " + Maybe.Absent.getException((Maybe)v));
                        log.trace("Trace of exception", (Throwable)Maybe.Absent.getException((Maybe)v));
                    } else {
                        log.debug(this + " not setting sensor " + sensor + " on " + entity + "; cannot resolve " + StaticSensor.this.initParam(STATIC_VALUE) + ", after timeout " + timeout + ": " + Maybe.Absent.getException((Maybe)v));
                        log.trace("Trace of exception", (Throwable)Maybe.Absent.getException((Maybe)v));
                    }
                    return null;
                }
                log.debug(this + " setting sensor " + sensor + " to " + v.get() + " on " + entity);
                return entity.sensors().set(sensor, v.get());
            }
        }
        Task setValue = Tasks.builder().displayName("Setting " + sensor + " on " + entity).body(new SetValue()).build();
        Entities.submit((Entity)entity, Tasks.sequential("Resolving and setting " + sensor + " on " + entity, new TaskAdaptable[]{resolveValue, setValue}));
    }
}

