/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.core.resolve.jackson.WrappedValue;
import org.apache.brooklyn.util.collections.MutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonShorthandDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonShorthandDeserializer.class);
    private final JavaType type;

    public JsonShorthandDeserializer() {
        this.type = null;
    }

    public JsonShorthandDeserializer(JavaType type) {
        this.type = type;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType t = property != null ? property.getType() : ctxt.getContextualType();
        if (t == null) {
            return this;
        }
        if (t instanceof MapLikeType) {
            return new JsonShorthandDeserializer(t.getContentType());
        }
        if (Collection.class.isAssignableFrom(t.getRawClass())) {
            return new JsonShorthandDeserializer(t.getContentType());
        }
        return new JsonShorthandDeserializer(t);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        TokenBuffer b = new TokenBuffer(p, ctxt);
        b.copyCurrentStructure(p);
        Object r1 = null;
        try {
            r1 = super.deserializeWithType(b.asParserOnFirstToken(), ctxt, typeDeserializer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (r1 != null && this.type.getRawClass().isInstance(r1)) {
            return r1;
        }
        return this.deserialize(b.asParserOnFirstToken(), ctxt);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.type == null) {
            return ctxt.findNonContextualValueDeserializer(ctxt.constructType(Object.class)).deserialize(p, ctxt);
        }
        MutableList exceptions = MutableList.of();
        try {
            TokenBuffer b = new TokenBuffer(p, ctxt);
            b.copyCurrentStructure(p);
            try {
                Object r1 = ctxt.findNonContextualValueDeserializer(this.type).deserialize(b.asParserOnFirstToken(), ctxt);
                if (r1 != null && this.type.getRawClass().isInstance(r1)) {
                    Object object = r1;
                    return object;
                }
            }
            catch (Exception e2) {
                exceptions.add(e2);
            }
            try {
                Object v2;
                Method inst = Arrays.stream(this.type.getRawClass().getMethods()).filter(m -> m.getAnnotation(JsonShorthandInstantiator.class) != null).findAny().orElseThrow(() -> new IllegalStateException("No public method annotated @JsonShorthandInstantiator"));
                if ((inst.getModifiers() & 8) == 0) {
                    throw new IllegalStateException("@JsonShorthandInstantiator method must be static: " + inst);
                }
                if (inst.getParameterCount() != 1) {
                    throw new IllegalStateException("@JsonShorthandInstantiator method should take a single argument: " + inst);
                }
                Object v = ctxt.findRootValueDeserializer(ctxt.constructType(inst.getParameters()[0].getParameterizedType())).deserialize(b.asParserOnFirstToken(), ctxt);
                if ((v instanceof Map || v instanceof WrappedValue && ((WrappedValue)v).getSupplier() == null && ((WrappedValue)v).get() instanceof Map) && !((v2 = ctxt.findNonContextualValueDeserializer(ctxt.constructType(inst.getParameters()[0].getParameterizedType())).deserialize(b.asParserOnFirstToken(), ctxt)) instanceof Map)) {
                    v = v2;
                }
                Object object = inst.invoke(null, v);
                return object;
            }
            catch (Exception e3) {
                exceptions.add(e3);
                throw new IllegalStateException("Cannot instantiate as longhand or shorthand: " + exceptions, exceptions.stream().findFirst().orElse(null));
            }
        }
        finally {
            if (!exceptions.isEmpty() && LOG.isTraceEnabled()) {
                LOG.trace("Exceptions encountered while deserializing: " + exceptions);
                exceptions.forEach(e -> LOG.trace("- ", (Throwable)e));
            }
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface JsonShorthandInstantiator {
    }
}

