/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedLocationResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(NamedLocationResolver.class);
    public static final String NAMED = "named";
    private ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public boolean isEnabled() {
        return LocationConfigUtils.isResolverPrefixEnabled(this.managementContext, this.getPrefix());
    }

    public LocationSpec<? extends Location> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        LocationDefinition ld;
        String name = spec;
        ConfigBag lfBag = ConfigBag.newInstance(locationFlags).putIfAbsent(LocationInternal.ORIGINAL_SPEC, name);
        name = Strings.removeFromStart((String)spec, (String)(this.getPrefix() + ":"));
        if (name.toLowerCase().startsWith("named:")) {
            log.warn("Deprecated use of 'named:' prefix with wrong case (" + spec + "); support may be removed in future versions");
            name = spec.substring("named:".length());
        }
        if ((ld = registry.getDefinedLocationByName(name)) == null) {
            throw new NoSuchElementException("No named location defined matching '" + name + "'");
        }
        return (LocationSpec)registry.getLocationSpec(ld, lfBag.getAllConfig()).get();
    }

    public String getPrefix() {
        return NAMED;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        if (BasicLocationRegistry.isResolverPrefixForSpec(this, spec, false)) {
            return true;
        }
        return registry.getDefinedLocationByName(spec) != null;
    }
}

