/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.route53.domain.ResourceRecordSet;

public class ResourceRecordSetIterable
extends IterableWithMarker<ResourceRecordSet> {
    private final Iterable<ResourceRecordSet> items;
    private final Optional<NextRecord> nextRecord;

    private ResourceRecordSetIterable(Iterable<ResourceRecordSet> items, @Nullable NextRecord nextRecord) {
        this.items = (Iterable)Preconditions.checkNotNull(items, (Object)"items");
        this.nextRecord = Optional.fromNullable((Object)nextRecord);
    }

    public Optional<NextRecord> nextRecord() {
        return this.nextRecord;
    }

    public Optional<Object> nextMarker() {
        return (Optional)Optional.class.cast(this.nextRecord);
    }

    public Iterator<ResourceRecordSet> iterator() {
        return this.items.iterator();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.items, this.nextRecord});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ResourceRecordSetIterable that = (ResourceRecordSetIterable)((Object)ResourceRecordSetIterable.class.cast(obj));
        return Objects.equal(this.items, that.items) && Objects.equal(this.nextRecord, that.nextRecord);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").omitNullValues().add("items", this.items).add("nextRecord", this.nextRecord.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ImmutableList.Builder<ResourceRecordSet> items = ImmutableList.builder();
        private String nextRecordName;
        private String nextRecordType;
        private String nextRecordIdentifier;

        public Builder add(ResourceRecordSet item) {
            this.items.add((Object)item);
            return this;
        }

        public Builder addAll(Iterable<ResourceRecordSet> items) {
            this.items.addAll(items);
            return this;
        }

        public Builder nextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
            return this;
        }

        public Builder nextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
            return this;
        }

        public Builder nextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
            return this;
        }

        public ResourceRecordSetIterable build() {
            NextRecord nextRecord = this.nextRecordName != null ? new NextRecord(this.nextRecordName, this.nextRecordType, this.nextRecordIdentifier) : null;
            return new ResourceRecordSetIterable((Iterable)this.items.build(), nextRecord);
        }
    }

    public static class NextRecord {
        private final String name;
        private final Optional<String> type;
        private final Optional<String> identifier;

        public static NextRecord name(String name) {
            return new NextRecord(name, null, null);
        }

        public static NextRecord nameAndType(String name, String type) {
            return new NextRecord(name, type, null);
        }

        public static NextRecord nameTypeAndIdentifier(String name, String type, String identifier) {
            return new NextRecord(name, type, identifier);
        }

        private NextRecord(String name, String type, String identifier) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.type = Optional.fromNullable((Object)type);
            this.identifier = Optional.fromNullable((Object)identifier);
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getType() {
            return this.type;
        }

        public Optional<String> getIdentifier() {
            return this.identifier;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.identifier});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NextRecord that = (NextRecord)NextRecord.class.cast(obj);
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.type, that.type) && Objects.equal(this.identifier, that.identifier);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").omitNullValues().add("name", (Object)this.name).add("type", this.type.orNull()).add("identifier", this.identifier.orNull()).toString();
        }
    }
}

