/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.relations;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.relations.RelationshipType;
import org.apache.brooklyn.core.relations.AbstractBasicRelationSupport;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;

public class ByObjectBasicRelationSupport<SourceType extends BrooklynObject>
extends AbstractBasicRelationSupport<SourceType> {
    DataForBasicRelations<SourceType> data;

    public ByObjectBasicRelationSupport(SourceType source, Runnable relationChangeCallback) {
        super(source);
        this.data = new DataForBasicRelations(relationChangeCallback);
    }

    @Override
    public BrooklynObject.RelationSupport<SourceType> getLocalBackingStore() {
        return this.data;
    }

    public static class DataForBasicRelations<T extends BrooklynObject>
    implements BrooklynObject.RelationSupport<T> {
        Runnable relationChangeCallback;
        private Map<String, RelationshipType<? super T, ? extends BrooklynObject>> relationshipTypes = MutableMap.of();
        private Multimap<String, BrooklynObject> relations = Multimaps.newMultimap((Map)MutableMap.of(), (Supplier)new Supplier<Collection<BrooklynObject>>(){

            public Collection<BrooklynObject> get() {
                return MutableSet.of();
            }
        });

        public DataForBasicRelations(Runnable relationChangeCallback) {
            this.relationChangeCallback = relationChangeCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<RelationshipType<? super T, ? extends BrooklynObject>> getRelationshipTypes() {
            Multimap<String, BrooklynObject> multimap = this.relations;
            synchronized (multimap) {
                return MutableSet.copyOf(this.relationshipTypes.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <U extends BrooklynObject> Set<U> getRelations(RelationshipType<? super T, U> relationship) {
            Multimap<String, BrooklynObject> multimap = this.relations;
            synchronized (multimap) {
                return MutableSet.copyOf((Iterable)this.relations.get((Object)relationship.getRelationshipTypeName()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <U extends BrooklynObject> void add(RelationshipType<? super T, ? super U> relationship, U target) {
            Multimap<String, BrooklynObject> multimap = this.relations;
            synchronized (multimap) {
                this.relationshipTypes.put(relationship.getRelationshipTypeName(), relationship);
                this.relations.put((Object)relationship.getRelationshipTypeName(), target);
            }
            this.onRelationsChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <U extends BrooklynObject> void remove(RelationshipType<? super T, ? super U> relationship, U target) {
            Multimap<String, BrooklynObject> multimap = this.relations;
            synchronized (multimap) {
                this.relations.remove((Object)relationship.getRelationshipTypeName(), target);
            }
            this.onRelationsChanged();
        }

        protected void onRelationsChanged() {
            if (this.relationChangeCallback != null) {
                this.relationChangeCallback.run();
            }
        }
    }
}

