/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.components.jaspi.impl;

import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.module.ClientAuthModule;

public class ClientAuthContextImpl
implements ClientAuthContext {
    private final List<ClientAuthModule> clientAuthModules;

    public ClientAuthContextImpl(List<ClientAuthModule> clientAuthModules) {
        this.clientAuthModules = clientAuthModules;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        for (ClientAuthModule clientAuthModule : this.clientAuthModules) {
            clientAuthModule.cleanSubject(messageInfo, subject);
        }
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        for (ClientAuthModule clientAuthModule : this.clientAuthModules) {
            AuthStatus result = clientAuthModule.secureRequest(messageInfo, clientSubject);
            if (result == AuthStatus.SUCCESS) continue;
            if (result == AuthStatus.SEND_CONTINUE || result == AuthStatus.FAILURE) {
                return result;
            }
            throw new AuthException("Invalid AuthStatus " + result + " from client auth module: " + clientAuthModule);
        }
        return AuthStatus.SUCCESS;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        for (ClientAuthModule clientAuthModule : this.clientAuthModules) {
            AuthStatus result = clientAuthModule.validateResponse(messageInfo, clientSubject, serviceSubject);
            if (result == AuthStatus.SUCCESS) continue;
            if (result == AuthStatus.SEND_CONTINUE || result == AuthStatus.FAILURE) {
                return result;
            }
            throw new AuthException("Invalid AuthStatus " + result + " from client auth module: " + clientAuthModule);
        }
        return AuthStatus.SUCCESS;
    }
}

