/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAttributesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EntityAttributesUtils.class);

    public static <T> T tryGetAttribute(Entity entity, AttributeSensor<T> sensor) {
        Object attribute = null;
        try {
            attribute = entity.getAttribute(sensor);
        }
        catch (Exception exception) {
            Exceptions.propagateIfFatal((Throwable)exception);
            LOG.warn("Error retrieving sensor " + sensor + " for " + entity + " (ignoring): " + exception);
        }
        return (T)attribute;
    }
}

