/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.api.ActivityApi;
import org.apache.brooklyn.rest.domain.TaskSummary;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.TaskTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;

public class ActivityResource
extends AbstractBrooklynRestResource
implements ActivityApi {
    public Response get(String taskId, String timeout, Boolean suppressSecrets) {
        Task<?> t = this.findTask(taskId);
        try {
            boolean ended;
            if (timeout == null || timeout.isEmpty() || "always".equalsIgnoreCase(timeout)) {
                timeout = "0";
            } else if ("never".equalsIgnoreCase(timeout)) {
                timeout = "-1";
            }
            Duration timeoutD = Time.parseDuration((String)timeout);
            if (timeoutD.isNegative()) {
                timeoutD = Duration.PRACTICALLY_FOREVER;
            }
            return Response.status((Response.Status)((ended = t.blockUntilEnded(timeoutD)) ? Response.Status.OK : Response.Status.ACCEPTED)).entity((Object)TaskTransformer.fromTask(this.ui.getBaseUriBuilder(), this.resolving(null), suppressSecrets).apply(t)).build();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Map<String, TaskSummary> getAllChildrenAsMap(String taskId, int limit, int maxDepth, Boolean suppressSecrets) {
        Task<?> parentTask = this.findTask(taskId);
        return this.getAllDescendantTasks(parentTask, limit, maxDepth, suppressSecrets);
    }

    protected Task<?> findTask(String taskId) {
        Task task = this.mgmt().getExecutionManager().getTask(taskId);
        if (task == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s' - possibly garbage collected to save memory", taskId);
        }
        this.checkEntityEntitled(task);
        return task;
    }

    private LinkedHashMap<String, TaskSummary> getAllDescendantTasks(Task<?> parentTask, int limit, int maxDepth, Boolean suppressSecrets) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (!(parentTask instanceof HasTaskChildren)) {
            return result;
        }
        MutableSet nextLayer = MutableSet.copyOf((Iterable)((HasTaskChildren)parentTask).getChildren());
        block0: while (limit != 0 && !nextLayer.isEmpty() && maxDepth-- != 0) {
            MutableSet thisLayer = nextLayer;
            nextLayer = MutableSet.of();
            for (Task childTask : thisLayer) {
                TaskSummary wasThere = result.put(childTask.getId(), TaskTransformer.fromTask(this.ui.getBaseUriBuilder(), this.resolving(null), suppressSecrets, false).apply(childTask));
                if (wasThere != null) continue;
                if (--limit == 0) break block0;
                if (!(childTask instanceof HasTaskChildren)) continue;
                Iterables.addAll((Collection)nextLayer, (Iterable)((HasTaskChildren)childTask).getChildren());
            }
        }
        return result;
    }

    public List<TaskSummary> children(String taskId, Boolean includeBackground, int limit, Boolean suppressSecrets) {
        Task<?> t = this.findTask(taskId);
        MutableList result = MutableList.copyOf(this.getSubTaskChildren(t));
        if (Boolean.TRUE.equals(includeBackground)) {
            result.addAll(this.getBackgroundedChildren(t));
        }
        return TaskTransformer.fromTasks(result, limit, false, null, this.ui, this.resolving(null), suppressSecrets);
    }

    private Collection<Task<?>> getBackgroundedChildren(Task<?> t) {
        Entity entity = BrooklynTaskTags.getContextEntity(t);
        MutableList result = MutableList.of();
        if (entity != null) {
            Set tasks = BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)this.mgmt().getExecutionManager(), (Entity)entity);
            for (Task ti : tasks) {
                if (!t.equals((Object)ti.getSubmittedByTask())) continue;
                result.add(ti);
            }
        }
        return result;
    }

    private Iterable<Task<?>> getSubTaskChildren(Task<?> t) {
        if (!(t instanceof HasTaskChildren)) {
            return Collections.emptyList();
        }
        return ((HasTaskChildren)t).getChildren();
    }

    public String stream(String taskId, String streamId) {
        Task<?> t = this.findTask(taskId);
        this.checkStreamEntitled(t, streamId);
        BrooklynTaskTags.WrappedStream stream = BrooklynTaskTags.stream(t, (String)streamId);
        if (stream == null) {
            throw WebResourceUtils.notFound("Cannot find stream '%s' in task '%s'", streamId, taskId);
        }
        return (String)stream.streamContents.get();
    }

    protected void checkEntityEntitled(Task<?> task) {
        Entity entity = BrooklynTaskTags.getContextEntity(task);
        if (entity != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see activity of entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
    }

    protected void checkStreamEntitled(Task<?> task, String streamId) {
        Entity entity = BrooklynTaskTags.getContextEntity(task);
        Entitlements.TaskAndItem item = new Entitlements.TaskAndItem(task, (Object)streamId);
        if (entity != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ACTIVITY_STREAMS, (Object)item)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see activity stream of entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
    }

    public Boolean cancel(String taskId, Boolean noInterrupt) {
        Task<?> t = this.findTask(taskId);
        return t.cancel(noInterrupt == null || noInterrupt == false);
    }
}

