/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import org.apache.brooklyn.util.os.Os;

public class FilePermissions {
    private final int posixMode;
    private final Set<PosixFilePermission> posixPermissions = EnumSet.noneOf(PosixFilePermission.class);

    public FilePermissions(int posixMode) {
        this.posixMode = posixMode;
        if ((posixMode & 0x100) != 0) {
            this.posixPermissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((posixMode & 0x80) != 0) {
            this.posixPermissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((posixMode & 0x40) != 0) {
            this.posixPermissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((posixMode & 0x20) != 0) {
            this.posixPermissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((posixMode & 0x10) != 0) {
            this.posixPermissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((posixMode & 8) != 0) {
            this.posixPermissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((posixMode & 4) != 0) {
            this.posixPermissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((posixMode & 2) != 0) {
            this.posixPermissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((posixMode & 1) != 0) {
            this.posixPermissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
    }

    public void apply(File file) throws IOException {
        Path filePath = file.toPath();
        boolean done = false;
        try {
            if (!Os.isMicrosoftWindows()) {
                Files.setPosixFilePermissions(filePath, this.posixPermissions);
            }
            done = true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (!done) {
            boolean setRead = file.setReadable(this.posixPermissions.contains((Object)PosixFilePermission.OTHERS_READ), false) & file.setReadable(this.posixPermissions.contains((Object)PosixFilePermission.OWNER_READ), true);
            boolean setWrite = file.setWritable(this.posixPermissions.contains((Object)PosixFilePermission.OTHERS_WRITE), false) & file.setWritable(this.posixPermissions.contains((Object)PosixFilePermission.OWNER_WRITE), true);
            boolean setExec = file.setExecutable(this.posixPermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE), false) & file.setExecutable(this.posixPermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE), true);
            if (!(setRead && setWrite && setExec)) {
                throw new IOException("setting file permissions failed: read=" + setRead + " write=" + setWrite + " exec=" + setExec);
            }
        }
    }

    public String toString() {
        return "posix mode " + Integer.toOctalString(this.posixMode);
    }
}

