/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;

public final class RunLengthIntArray {
    private final IntArrayList blockValues = new IntArrayList();
    private int[] blockCounts = new int[32];
    private int lastSeen;
    private int size;

    public RunLengthIntArray() {
        this.reset();
    }

    public void reset() {
        this.blockValues.clear();
        this.lastSeen = -1;
        this.size = 0;
    }

    public void add(int value) {
        if (this.size == 0 || value != this.lastSeen) {
            this.lastSeen = value;
            this.newBlock();
            this.blockValues.add(value);
        }
        int n = this.blockValues.size() - 1;
        this.blockCounts[n] = this.blockCounts[n] + 1;
        ++this.size;
    }

    public void add(int value, int count) {
        if (count == 0) {
            return;
        }
        if (this.size == 0 || value != this.lastSeen) {
            this.lastSeen = value;
            this.newBlock();
            this.blockValues.add(value);
        }
        int n = this.blockValues.size() - 1;
        this.blockCounts[n] = this.blockCounts[n] + count;
        this.size += count;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumberOfBlocks() {
        return this.blockValues.size();
    }

    public int getBlockValue(int blockIndex) {
        return this.blockValues.getInt(blockIndex);
    }

    public int getBlockSize(int blockIndex) {
        if (blockIndex == 0) {
            return this.blockCounts[blockIndex];
        }
        return this.blockCounts[blockIndex] - this.blockCounts[blockIndex - 1];
    }

    public int getBlockSize(int blockIndex, int startIndex) {
        return this.blockCounts[blockIndex] - startIndex;
    }

    public int getBlockIndex(int startIndex) {
        if (startIndex >= this.size) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + " >= size:" + this.size);
        }
        int index = Arrays.binarySearch(this.blockCounts, 0, this.blockValues.size(), startIndex);
        if (index < 0) {
            index = Math.abs(index) - 1;
        }
        return index;
    }

    public void add(RunLengthIntArray other, int startIndex) {
        if (startIndex >= other.size) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + " >= other size:" + this.size);
        }
        int otherBlockIndex = other.getBlockIndex(startIndex);
        int otherBlockSizeRemaining = other.getBlockSize(otherBlockIndex, startIndex);
        this.add(other.getBlockValue(otherBlockIndex), otherBlockSizeRemaining);
        for (int i = otherBlockIndex + 1; i < other.getNumberOfBlocks(); ++i) {
            this.add(other.getBlockValue(i), other.getBlockSize(i));
        }
    }

    private void newBlock() {
        int newBlockIndex = this.blockValues.size();
        if (newBlockIndex == this.blockCounts.length) {
            int[] newRepCount = new int[this.blockCounts.length * 2];
            System.arraycopy(this.blockCounts, 0, newRepCount, 0, this.blockCounts.length);
            this.blockCounts = newRepCount;
        }
        if (newBlockIndex > 0) {
            this.blockCounts[newBlockIndex] = this.blockCounts[newBlockIndex - 1];
        } else {
            this.blockCounts[0] = 0;
        }
    }

    public String toString() {
        int i;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("size: ");
        builder.append(this.getSize());
        builder.append(" [");
        for (i = 0; i < this.getNumberOfBlocks() - 1; ++i) {
            this.appendBlockInfo(i, builder);
            builder.append(',');
        }
        this.appendBlockInfo(i, builder);
        builder.append(']');
        return builder.toString();
    }

    private void appendBlockInfo(int blockIndex, StringBuilder builder) {
        builder.append('(');
        builder.append(this.getBlockValue(blockIndex));
        builder.append(',');
        builder.append(this.getBlockSize(blockIndex));
        builder.append(')');
    }
}

