/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.encoder;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.column.bytes.encoder.AbstractParquetDeltaBinaryPackingValuesWriter;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetEncodingException;

public class ParquetDeltaBinaryPackingValuesWriterForInteger
extends AbstractParquetDeltaBinaryPackingValuesWriter {
    private static final int MAX_BITWIDTH = 32;
    private final int blockSizeInValues;
    private final int miniBlockNumInABlock;
    private final int miniBlockSizeInValues;
    private final int[] deltaBlockBuffer;
    private int firstValue = 0;
    private int previousValue = 0;
    private int minDeltaInCurrentBlock = Integer.MAX_VALUE;
    private int maxDeltaInCurrentBlock = Integer.MIN_VALUE;
    private int estimatedSize = 0;

    public ParquetDeltaBinaryPackingValuesWriterForInteger(Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        this(128, 4, multiPageOpRef);
    }

    public ParquetDeltaBinaryPackingValuesWriterForInteger(int blockSizeInValues, int miniBlockNum, Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        super(blockSizeInValues, miniBlockNum, multiPageOpRef);
        this.blockSizeInValues = blockSizeInValues;
        this.miniBlockNumInABlock = miniBlockNum;
        double miniSize = (double)blockSizeInValues / (double)this.miniBlockNumInABlock;
        Preconditions.checkArgument((miniSize % 8.0 == 0.0 ? 1 : 0) != 0, (String)("miniBlockSize must be multiple of 8, but it's " + miniSize));
        this.miniBlockSizeInValues = (int)miniSize;
        this.deltaBlockBuffer = new int[blockSizeInValues];
        this.miniBlockByteBuffer = new byte[this.miniBlockSizeInValues * 32];
    }

    @Override
    public void writeInteger(int v) {
        ++this.totalValueCount;
        if (this.totalValueCount == 1) {
            this.previousValue = this.firstValue = v;
            return;
        }
        int delta = v - this.previousValue;
        this.previousValue = v;
        this.deltaBlockBuffer[this.deltaValuesToFlush++] = delta;
        if (delta < this.minDeltaInCurrentBlock) {
            this.minDeltaInCurrentBlock = delta;
        }
        if (this.blockSizeInValues == this.deltaValuesToFlush) {
            this.flushBlockBuffer();
        } else if (delta > this.maxDeltaInCurrentBlock) {
            this.maxDeltaInCurrentBlock = delta;
            this.estimatedElementSize = 64 - Long.numberOfLeadingZeros(this.maxDeltaInCurrentBlock - this.minDeltaInCurrentBlock);
            this.estimatedSize = this.estimatedElementSize * this.deltaValuesToFlush;
        } else {
            this.estimatedSize += this.estimatedElementSize;
        }
    }

    private void flushBlockBuffer() {
        int i;
        for (int i2 = 0; i2 < this.deltaValuesToFlush; ++i2) {
            this.deltaBlockBuffer[i2] = this.deltaBlockBuffer[i2] - this.minDeltaInCurrentBlock;
        }
        this.writeMinDelta();
        int miniBlocksToFlush = this.getMiniBlockCountToFlush(this.deltaValuesToFlush);
        this.calculateBitWidthsForDeltaBlockBuffer(miniBlocksToFlush);
        for (i = 0; i < this.miniBlockNumInABlock; ++i) {
            this.writeBitWidthForMiniBlock(i);
        }
        for (i = 0; i < miniBlocksToFlush; ++i) {
            int miniBlockStart;
            int currentBitWidth = this.bitWidths[i];
            int blockOffset = 0;
            BytePacker packer = Packer.LITTLE_ENDIAN.newBytePacker(currentBitWidth);
            for (int j = miniBlockStart = i * this.miniBlockSizeInValues; j < (i + 1) * this.miniBlockSizeInValues; j += 8) {
                packer.pack8Values(this.deltaBlockBuffer, j, this.miniBlockByteBuffer, blockOffset);
                blockOffset += currentBitWidth;
            }
            try {
                this.outputStream.write(this.miniBlockByteBuffer, 0, blockOffset);
                continue;
            }
            catch (IOException e) {
                throw new ParquetEncodingException((Throwable)e);
            }
        }
        this.minDeltaInCurrentBlock = Integer.MAX_VALUE;
        this.deltaValuesToFlush = 0;
        this.estimatedSize = 0;
        this.maxDeltaInCurrentBlock = Integer.MIN_VALUE;
    }

    private void writeMinDelta() {
        try {
            BytesUtils.writeZigZagVarInt((int)this.minDeltaInCurrentBlock, (OutputStream)this.outputStream);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("can not write min delta for block", (Throwable)e);
        }
    }

    private void calculateBitWidthsForDeltaBlockBuffer(int miniBlocksToFlush) {
        for (int miniBlockIndex = 0; miniBlockIndex < miniBlocksToFlush; ++miniBlockIndex) {
            int mask = 0;
            int miniStart = miniBlockIndex * this.miniBlockSizeInValues;
            int miniEnd = Math.min((miniBlockIndex + 1) * this.miniBlockSizeInValues, this.deltaValuesToFlush);
            for (int i = miniStart; i < miniEnd; ++i) {
                mask |= this.deltaBlockBuffer[i];
            }
            this.bitWidths[miniBlockIndex] = 32 - Integer.numberOfLeadingZeros(mask);
        }
    }

    @Override
    public BytesInput getBytes() {
        if (this.deltaValuesToFlush != 0) {
            this.flushBlockBuffer();
        }
        BytesInput configBytes = BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.fromUnsignedVarInt((int)this.blockSizeInValues), BytesInput.fromUnsignedVarInt((int)this.miniBlockNumInABlock)});
        return BytesInput.concat((BytesInput[])new BytesInput[]{configBytes, BytesInput.fromUnsignedVarInt((int)this.totalValueCount), BytesInput.fromZigZagVarInt((int)this.firstValue), this.outputStream.asBytesInput()});
    }

    @Override
    public void reset() throws HyracksDataException {
        super.reset();
        this.minDeltaInCurrentBlock = Integer.MAX_VALUE;
        this.estimatedSize = 0;
        this.maxDeltaInCurrentBlock = Integer.MIN_VALUE;
    }

    @Override
    public void close() {
        super.close();
        this.minDeltaInCurrentBlock = Integer.MAX_VALUE;
        this.estimatedSize = 0;
        this.maxDeltaInCurrentBlock = Integer.MIN_VALUE;
    }
}

