/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.column.assembler.AbstractNestedValueAssembler;
import org.apache.asterix.column.assembler.AbstractValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public class ObjectValueAssembler
extends AbstractNestedValueAssembler {
    private final RecordBuilder recordBuilder = new RecordBuilder();
    private final ARecordType recordType;

    ObjectValueAssembler(int level, AssemblerInfo info) {
        super(level, info);
        this.recordType = (ARecordType)info.getDeclaredType();
    }

    @Override
    void reset() {
        this.recordBuilder.reset(this.recordType);
        this.storage.reset();
    }

    @Override
    void addValue(AbstractValueAssembler value) throws HyracksDataException {
        int valueIndex = value.getFieldIndex();
        if (valueIndex >= 0) {
            this.recordBuilder.addField(valueIndex, value.getValue());
        } else {
            this.recordBuilder.addField(value.getFieldName(), value.getValue());
        }
    }

    @Override
    void addNull(AbstractValueAssembler value) throws HyracksDataException {
        int valueIndex = value.getFieldIndex();
        if (valueIndex >= 0) {
            this.recordBuilder.addField(valueIndex, (IValueReference)NULL);
        } else {
            this.recordBuilder.addField(value.getFieldName(), (IValueReference)NULL);
        }
    }

    @Override
    void addValueToParent() throws HyracksDataException {
        this.storage.reset();
        this.recordBuilder.write(this.storage.getDataOutput(), true);
        this.getParent().addValue(this);
    }

    @Override
    public IValueReference getValue() {
        return this.storage;
    }
}

