/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.column.ColumnManager;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnTupleReaderWriterFactory;
import org.apache.asterix.column.operation.lsm.load.LoadColumnTupleReaderWriterFactory;
import org.apache.asterix.column.operation.lsm.merge.MergeColumnTupleReaderWriterFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleReaderWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnManager;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnManagerFactory;

public final class ColumnManagerFactory
implements IColumnManagerFactory {
    private static final long serialVersionUID = -5003159552950739235L;
    private final ARecordType datasetType;
    private final ARecordType metaType;
    private final List<List<String>> primaryKeys;
    private final List<Integer> keySourceIndicator;
    private final int pageSize;
    private final int maxTupleCount;
    private final double tolerance;
    private final int maxLeafNodeSize;

    public ColumnManagerFactory(ARecordType datasetType, ARecordType metaType, List<List<String>> primaryKeys, List<Integer> keySourceIndicator, int pageSize, int maxTupleCount, double tolerance, int maxLeafNodeSize) {
        this.pageSize = pageSize;
        this.maxTupleCount = maxTupleCount;
        this.tolerance = tolerance;
        this.maxLeafNodeSize = maxLeafNodeSize;
        this.datasetType = datasetType;
        if (ColumnManagerFactory.containsSplitKeys(keySourceIndicator)) {
            throw new UnsupportedOperationException("Primary keys split between meta-type and datasetType is not supported");
        }
        this.keySourceIndicator = keySourceIndicator;
        this.metaType = metaType;
        this.primaryKeys = primaryKeys;
    }

    public IColumnManager createColumnManager() {
        return new ColumnManager(this.datasetType, this.metaType, this.primaryKeys, this.keySourceIndicator);
    }

    public AbstractColumnTupleReaderWriterFactory getLoadColumnTupleReaderWriterFactory(IBinaryComparatorFactory[] cmpFactories) {
        return new LoadColumnTupleReaderWriterFactory(this.pageSize, this.maxTupleCount, this.tolerance, this.maxLeafNodeSize, cmpFactories);
    }

    public AbstractColumnTupleReaderWriterFactory getFlushColumnTupleReaderWriterFactory() {
        return new FlushColumnTupleReaderWriterFactory(this.pageSize, this.maxTupleCount, this.tolerance, this.maxLeafNodeSize);
    }

    public AbstractColumnTupleReaderWriterFactory createMergeColumnTupleReaderWriterFactory() {
        return new MergeColumnTupleReaderWriterFactory(this.pageSize, this.maxTupleCount, this.tolerance, this.maxLeafNodeSize);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), -5003159552950739235L);
        json.putPOJO("datasetType", (Object)this.datasetType.toJson(registry));
        if (this.metaType != null) {
            json.putPOJO("metaType", (Object)this.metaType.toJson(registry));
        }
        json.put("pageSize", this.pageSize);
        json.put("maxTupleCount", this.maxTupleCount);
        json.put("tolerance", this.tolerance);
        json.put("maxLeafNodeSize", this.maxLeafNodeSize);
        ArrayNode primaryKeysArray = json.putArray("primaryKeys");
        for (List<String> primaryKey : this.primaryKeys) {
            ArrayNode primaryKeyArray = primaryKeysArray.addArray();
            for (String path : primaryKey) {
                primaryKeyArray.add(path);
            }
        }
        ArrayNode keySourceIndicatorNode = json.putArray("keySourceIndicator");
        for (int keySourceIndicatorInt : this.keySourceIndicator) {
            keySourceIndicatorNode.add(keySourceIndicatorInt);
        }
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        ARecordType datasetType = (ARecordType)registry.deserialize(json.get("datasetType"));
        JsonNode metaItemTypeNode = json.get("metaType");
        ARecordType metaType = null;
        if (metaItemTypeNode != null) {
            metaType = (ARecordType)registry.deserialize(metaItemTypeNode);
        }
        int pageSize = json.get("pageSize").asInt();
        int maxTupleCount = json.get("maxTupleCount").asInt();
        double tolerance = json.get("tolerance").asDouble();
        int maxLeafNodeSize = json.get("maxLeafNodeSize").asInt();
        ArrayList<List<String>> primaryKeys = new ArrayList<List<String>>();
        ArrayNode primaryKeysNode = (ArrayNode)json.get("primaryKeys");
        for (int i = 0; i < primaryKeysNode.size(); ++i) {
            ArrayList<String> primaryKey = new ArrayList<String>();
            ArrayNode primaryKeyNode = (ArrayNode)primaryKeysNode.get(i);
            for (int j = 0; j < primaryKeyNode.size(); ++j) {
                primaryKey.add(primaryKeyNode.get(j).asText());
            }
            primaryKeys.add(primaryKey);
        }
        ArrayList<Integer> keySourceIndicator = new ArrayList<Integer>();
        ArrayNode keySourceIndicatorNode = (ArrayNode)json.get("keySourceIndicator");
        for (int i = 0; i < keySourceIndicatorNode.size(); ++i) {
            keySourceIndicator.add(keySourceIndicatorNode.get(i).asInt());
        }
        return new ColumnManagerFactory(datasetType, metaType, primaryKeys, keySourceIndicator, pageSize, maxTupleCount, tolerance, maxLeafNodeSize);
    }

    private static boolean containsSplitKeys(List<Integer> keySourceIndicator) {
        if (keySourceIndicator.size() == 1) {
            return false;
        }
        Integer value = keySourceIndicator.get(0);
        for (int i = 1; i < keySourceIndicator.size(); ++i) {
            if (Objects.equals(value, keySourceIndicator.get(i))) continue;
            return true;
        }
        return false;
    }
}

