/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env.resources;

import com.couchbase.client.core.env.resources.ShutdownHook;
import com.couchbase.client.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;

public class IoPoolShutdownHook
implements ShutdownHook {
    private final EventLoopGroup ioPool;
    private volatile boolean shutdown;

    public IoPoolShutdownHook(EventLoopGroup ioPool) {
        this.ioPool = ioPool;
        this.shutdown = false;
    }

    @Override
    public Observable<Boolean> shutdown() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

            public void call(final Subscriber<? super Boolean> subscriber) {
                IoPoolShutdownHook.this.ioPool.shutdownGracefully(0L, 10L, TimeUnit.MILLISECONDS).addListener(new GenericFutureListener(){

                    public void operationComplete(Future future) throws Exception {
                        if (!subscriber.isUnsubscribed()) {
                            try {
                                if (future.isSuccess()) {
                                    subscriber.onNext((Object)true);
                                    IoPoolShutdownHook.this.shutdown = true;
                                    subscriber.onCompleted();
                                } else {
                                    subscriber.onError(future.cause());
                                }
                            }
                            catch (Exception ex) {
                                subscriber.onError((Throwable)ex);
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }
}

