/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class HttpAuthorization {
    private final String scheme;
    private final String parameter;

    public HttpAuthorization(String scheme, String parameter) {
        Objects.requireNonNull(scheme, "'scheme' cannot be null.");
        Objects.requireNonNull(parameter, "'parameter' cannot be null.");
        ClientLogger logger = new ClientLogger(HttpAuthorization.class);
        if (scheme.isEmpty()) {
            throw logger.logExceptionAsError(new IllegalArgumentException("'scheme' cannot be empty."));
        }
        if (parameter.isEmpty()) {
            throw logger.logExceptionAsError(new IllegalArgumentException("'parameter' cannot be empty."));
        }
        this.scheme = scheme;
        this.parameter = parameter;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String toString() {
        return this.scheme + " " + this.parameter;
    }
}

