/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.aws;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStream;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.aws.s3.S3Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.util.LogRedactionUtil;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class AwsS3InputStream
extends AbstractExternalInputStream {
    private final String bucket;
    private final S3Client s3Client;
    private static final int MAX_RETRIES = 5;

    public AwsS3InputStream(Map<String, String> configuration, List<String> filePaths) throws HyracksDataException {
        super(configuration, filePaths);
        this.s3Client = this.buildAwsS3Client(configuration);
        this.bucket = configuration.get("container");
    }

    @Override
    protected boolean getInputStream() throws IOException {
        String fileName = (String)this.filePaths.get(this.nextFileIndex);
        GetObjectRequest.Builder getObjectBuilder = GetObjectRequest.builder();
        GetObjectRequest getObjectRequest = (GetObjectRequest)getObjectBuilder.bucket(this.bucket).key((String)this.filePaths.get(this.nextFileIndex)).build();
        if (!this.doGetInputStream(getObjectRequest)) {
            return false;
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".gz") || StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".gzip")) {
            this.in = new GZIPInputStream(this.in, ExternalDataConstants.DEFAULT_BUFFER_SIZE);
        }
        return true;
    }

    private boolean doGetInputStream(GetObjectRequest request) throws RuntimeDataException {
        int retries = 0;
        while (retries < 5) {
            try {
                this.in = this.s3Client.getObject(request);
                break;
            }
            catch (NoSuchKeyException ex) {
                LOGGER.debug(() -> "Key " + LogRedactionUtil.userData((String)request.key()) + " was not found in bucket " + request.bucket());
                return false;
            }
            catch (S3Exception ex) {
                if (!this.shouldRetry(ex.awsErrorDetails().errorCode(), retries++)) {
                    throw new RuntimeDataException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
                LOGGER.debug(() -> "S3 retryable error: " + LogRedactionUtil.userData((String)ex.getMessage()));
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(retries < 3 ? 1L : 2L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (SdkException ex) {
                throw new RuntimeDataException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
        }
        return true;
    }

    private boolean shouldRetry(String errorCode, int currentRetry) {
        return currentRetry < 5 && S3Utils.isRetryableError(errorCode);
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            CleanupUtils.close((AutoCloseable)this.in, null);
        }
        if (this.s3Client != null) {
            CleanupUtils.close((AutoCloseable)this.s3Client, null);
        }
    }

    @Override
    public boolean stop() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private S3Client buildAwsS3Client(Map<String, String> configuration) throws HyracksDataException {
        try {
            return S3Utils.buildAwsS3Client(configuration);
        }
        catch (CompilationException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }
}

