/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.concurrent.atomic.AtomicLong;

class AbfsOperationMetrics {
    private final AtomicLong bytesFailed;
    private final AtomicLong bytesSuccessful;
    private final AtomicLong operationsFailed;
    private final AtomicLong operationsSuccessful;
    private long endTime;
    private final long startTime;

    AbfsOperationMetrics(long startTime) {
        this.startTime = startTime;
        this.bytesFailed = new AtomicLong();
        this.bytesSuccessful = new AtomicLong();
        this.operationsFailed = new AtomicLong();
        this.operationsSuccessful = new AtomicLong();
    }

    AtomicLong getBytesFailed() {
        return this.bytesFailed;
    }

    AtomicLong getBytesSuccessful() {
        return this.bytesSuccessful;
    }

    AtomicLong getOperationsFailed() {
        return this.operationsFailed;
    }

    AtomicLong getOperationsSuccessful() {
        return this.operationsSuccessful;
    }

    long getEndTime() {
        return this.endTime;
    }

    void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    long getStartTime() {
        return this.startTime;
    }

    void addBytesFailed(long bytes) {
        this.getBytesFailed().addAndGet(bytes);
    }

    void addBytesSuccessful(long bytes) {
        this.getBytesSuccessful().addAndGet(bytes);
    }

    void incrementOperationsFailed() {
        this.getOperationsFailed().incrementAndGet();
    }

    void incrementOperationsSuccessful() {
        this.getOperationsSuccessful().incrementAndGet();
    }
}

