/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.external.feed.watch.WaitForStateSubscriber;
import org.apache.asterix.external.operators.FeedIntakeOperatorNodePushable;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.utils.FeedOperations;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;

public class FeedEventsListener
extends ActiveEntityEventsListener {
    private final Feed feed;
    private final List<FeedConnection> feedConnections;
    private final ILangExtension.Language translatorLang;

    public FeedEventsListener(IStatementExecutor statementExecutor, ICcApplicationContext appCtx, IHyracksClientConnection hcc, EntityId entityId, List<Dataset> datasets, AlgebricksAbsolutePartitionConstraint locations, String runtimeName, IRetryPolicyFactory retryPolicyFactory, Feed feed, List<FeedConnection> feedConnections, ILangExtension.Language translatorLang) throws HyracksDataException {
        super(statementExecutor, appCtx, hcc, entityId, datasets, locations, runtimeName, retryPolicyFactory);
        this.feed = feed;
        this.feedConnections = feedConnections;
        this.translatorLang = translatorLang;
    }

    @Override
    public synchronized boolean remove(Dataset dataset) throws HyracksDataException {
        super.remove(dataset);
        this.feedConnections.removeIf(o -> o.getDataverseName().equals((Object)dataset.getDataverseName()) && o.getDatasetName().equals(dataset.getDatasetName()));
        return false;
    }

    public synchronized void addFeedConnection(FeedConnection feedConnection) {
        this.feedConnections.add(feedConnection);
    }

    public Feed getFeed() {
        return this.feed;
    }

    @Override
    public synchronized void start(MetadataProvider metadataProvider) throws HyracksDataException, InterruptedException {
        super.start(metadataProvider);
        boolean wait = Boolean.parseBoolean((String)metadataProvider.getConfig().get("wait-for-completion-feed"));
        if (wait) {
            WaitForStateSubscriber stoppedSubscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, EnumSet.of(ActivityState.STOPPED));
            stoppedSubscriber.sync();
        }
    }

    @Override
    protected JobId compileAndStartJob(MetadataProvider mdProvider) throws HyracksDataException {
        try {
            Pair<JobSpecification, AlgebricksAbsolutePartitionConstraint> jobInfo = FeedOperations.buildStartFeedJob(mdProvider, this.feed, this.feedConnections, this.statementExecutor, this.hcc);
            JobSpecification feedJob = (JobSpecification)jobInfo.getLeft();
            feedJob.setProperty("ActiveJob", (Serializable)this.entityId);
            this.setLocations((AlgebricksAbsolutePartitionConstraint)jobInfo.getRight());
            return JobUtils.runJob((IHyracksClientConnection)this.hcc, (JobSpecification)feedJob, (boolean)false);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    protected void setRunning(MetadataProvider metadataProvider, boolean running) {
    }

    @Override
    protected void doSuspend(MetadataProvider metadataProvider) throws HyracksDataException {
        throw new RuntimeDataException(ErrorCode.OPERATION_NOT_SUPPORTED, new Serializable[0]);
    }

    @Override
    protected void doResume(MetadataProvider metadataProvider) throws HyracksDataException {
        throw new RuntimeDataException(ErrorCode.OPERATION_NOT_SUPPORTED, new Serializable[0]);
    }

    @Override
    protected ActiveRuntimeId getActiveRuntimeId(int partition) {
        return new ActiveRuntimeId(this.entityId, FeedIntakeOperatorNodePushable.class.getSimpleName(), partition);
    }
}

