/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class MsalToken
extends AccessToken {
    private IAuthenticationResult authenticationResult;

    public MsalToken(IAuthenticationResult msalResult) {
        super(msalResult.accessToken(), OffsetDateTime.ofInstant(msalResult.expiresOnDate().toInstant(), ZoneOffset.UTC));
        this.authenticationResult = msalResult;
    }

    public IAccount getAccount() {
        return this.authenticationResult.account();
    }

    public IAuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }
}

