/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesResponse;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetAllResourceProfilesResponsePBImpl
extends GetAllResourceProfilesResponse {
    private YarnServiceProtos.GetAllResourceProfilesResponseProto proto = YarnServiceProtos.GetAllResourceProfilesResponseProto.getDefaultInstance();
    private YarnServiceProtos.GetAllResourceProfilesResponseProto.Builder builder = null;
    private boolean viaProto = false;
    private Map<String, Resource> profiles;

    public GetAllResourceProfilesResponsePBImpl() {
        this.builder = YarnServiceProtos.GetAllResourceProfilesResponseProto.newBuilder();
    }

    public GetAllResourceProfilesResponsePBImpl(YarnServiceProtos.GetAllResourceProfilesResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetAllResourceProfilesResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetAllResourceProfilesResponseProto.newBuilder((YarnServiceProtos.GetAllResourceProfilesResponseProto)this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.profiles != null) {
            this.addProfilesToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void addProfilesToProto() {
        this.maybeInitBuilder();
        this.builder.clearResourceProfiles();
        if (this.profiles == null) {
            return;
        }
        YarnProtos.ResourceProfilesProto.Builder profilesBuilder = YarnProtos.ResourceProfilesProto.newBuilder();
        for (Map.Entry<String, Resource> entry : this.profiles.entrySet()) {
            YarnProtos.ResourceProfileEntry.Builder profileEntry = YarnProtos.ResourceProfileEntry.newBuilder();
            profileEntry.setName(entry.getKey());
            profileEntry.setResources(this.convertToProtoFormat(entry.getValue()));
            profilesBuilder.addResourceProfilesMap(profileEntry);
        }
        this.builder.setResourceProfiles(profilesBuilder.build());
    }

    public void setResourceProfiles(Map<String, Resource> resourceProfiles) {
        this.initResourceProfiles();
        this.profiles.clear();
        this.profiles.putAll(resourceProfiles);
    }

    public Map<String, Resource> getResourceProfiles() {
        this.initResourceProfiles();
        return this.profiles;
    }

    private void initResourceProfiles() {
        if (this.profiles != null) {
            return;
        }
        this.profiles = new HashMap<String, Resource>();
        YarnServiceProtos.GetAllResourceProfilesResponseProto p = this.viaProto ? this.proto : this.builder;
        List profilesList = p.getResourceProfiles().getResourceProfilesMapList();
        for (YarnProtos.ResourceProfileEntry entry : profilesList) {
            this.profiles.put(entry.getName(), new ResourcePBImpl(entry.getResources()));
        }
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource res) {
        return ProtoUtils.convertToProtoFormat(res);
    }
}

