/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.CapabilityHeader;
import org.apache.aries.subsystem.core.archive.ClauseTokenizer;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.ExportPackageCapability;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;
import org.apache.aries.subsystem.core.archive.VersionAttribute;
import org.osgi.resource.Resource;

public class ExportPackageHeader
implements CapabilityHeader<Clause> {
    public static final String NAME = "Export-Package";
    private final Set<Clause> clauses = new HashSet<Clause>();

    public ExportPackageHeader(String value) {
        for (String clause : new ClauseTokenizer(value).getClauses()) {
            this.clauses.add(new Clause(clause));
        }
        if (this.clauses.isEmpty()) {
            throw new IllegalArgumentException("An Export-Package header must have at least one clause");
        }
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<ExportPackageCapability> toCapabilities(Resource resource) {
        ArrayList<ExportPackageCapability> result = new ArrayList<ExportPackageCapability>();
        for (Clause clause : this.clauses) {
            result.addAll(clause.toCapabilities(resource));
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        public static final String ATTRIBUTE_VERSION = "version";
        public static final String DIRECTIVE_EXCLUDE = "exclude";
        public static final String DIRECTIVE_INCLUDE = "include";
        public static final String DIRECTIVE_MANDATORY = "mandatory";
        public static final String DIRECTIVE_USES = "uses";
        private static final Pattern PATTERN_PACKAGENAME = Pattern.compile("(\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*)(?=;|\\z)");
        private static final Pattern PATTERN_PACKAGENAMES = Pattern.compile("(\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*\\s*(?:\\;\\s*\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*)*)(?=;|\\z)");
        private static final Pattern PATTERN_PARAMETER = Pattern.compile("((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)");
        private final Collection<String> packageNames = new HashSet<String>();
        private final String path;
        private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();

        private static void fillInDefaults(Map<String, Parameter> parameters) {
            Parameter parameter = parameters.get(ATTRIBUTE_VERSION);
            if (parameter == null) {
                parameters.put(ATTRIBUTE_VERSION, VersionAttribute.DEFAULT);
            }
        }

        public Clause(String clause) {
            Matcher main = PATTERN_PACKAGENAMES.matcher(clause);
            if (!main.find()) {
                throw new IllegalArgumentException("Missing package names path: " + clause);
            }
            this.path = main.group();
            Matcher path = PATTERN_PACKAGENAME.matcher(this.path);
            while (path.find()) {
                this.packageNames.add(main.group());
            }
            main.usePattern(PATTERN_PARAMETER);
            while (main.find()) {
                Parameter parameter = ParameterFactory.create(main.group());
                this.parameters.put(parameter.getName(), parameter);
            }
            Clause.fillInDefaults(this.parameters);
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        public Collection<String> getPackageNames() {
            return Collections.unmodifiableCollection(this.packageNames);
        }

        @Override
        public Parameter getParameter(String name) {
            return this.parameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.parameters.values());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public Collection<ExportPackageCapability> toCapabilities(Resource resource) {
            ArrayList<ExportPackageCapability> result = new ArrayList<ExportPackageCapability>(this.packageNames.size());
            for (String packageName : this.packageNames) {
                result.add(new ExportPackageCapability(packageName, this.parameters.values(), resource));
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

