/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.SubsystemSymbolicNameHeader;
import org.osgi.framework.Version;

public class SubsystemUri {
    private static final String REGEXP = "([^=]*)=([^&]*)&?";
    private static final Pattern PATTERN = Pattern.compile("([^=]*)=([^&]*)&?");
    private final String symbolicName;
    private final URL url;
    private final Version version;

    public SubsystemUri(String location) throws URISyntaxException, MalformedURLException {
        if (!location.startsWith("subsystem://")) {
            throw new IllegalArgumentException(location);
        }
        URI uri = new URI(location);
        this.url = uri.getAuthority() != null ? new URL(uri.getAuthority()) : null;
        Matcher matcher = PATTERN.matcher(uri.getQuery());
        String symbolicName = null;
        Version version = Version.emptyVersion;
        while (matcher.find()) {
            String name = matcher.group(1);
            if ("Subsystem-SymbolicName".equals(name)) {
                symbolicName = new SubsystemSymbolicNameHeader(matcher.group(2)).getValue();
                continue;
            }
            if ("Subsystem-Version".equals(name)) {
                version = Version.parseVersion((String)matcher.group(2));
                continue;
            }
            throw new IllegalArgumentException("Unsupported subsystem URI parameter: " + name);
        }
        this.symbolicName = symbolicName;
        this.version = version;
    }

    public SubsystemUri(String symbolicName, Version version, URL url) {
        if (symbolicName == null || symbolicName.length() == 0) {
            throw new IllegalArgumentException("Missing required parameter: symbolicName");
        }
        this.symbolicName = symbolicName;
        this.version = version;
        this.url = url;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public URL getURL() {
        return this.url;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("subsystem://");
        if (this.url != null) {
            try {
                builder.append(URLEncoder.encode(this.url.toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                builder.append(URLEncoder.encode(this.url.toString()));
            }
        }
        builder.append('?').append("Subsystem-SymbolicName").append('=').append(this.symbolicName);
        if (this.version != null) {
            builder.append('&').append("Subsystem-Version").append('=').append(this.version);
        }
        return builder.toString();
    }
}

