/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.legacy8ujsse.sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import org.openjsse.legacy8ujsse.sun.security.ssl.Debug;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeInStream;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeMessage;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeOutStream;
import org.openjsse.legacy8ujsse.sun.security.ssl.JsseJce;
import org.openjsse.legacy8ujsse.sun.security.ssl.ProtocolVersion;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.util.KeyUtil;

final class RSAClientKeyExchange
extends HandshakeMessage {
    private ProtocolVersion protocolVersion;
    SecretKey preMaster;
    private byte[] encrypted;

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion maxVersion, SecureRandom generator, PublicKey publicKey) throws IOException {
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Public key not of type RSA: " + publicKey.getAlgorithm());
        }
        this.protocolVersion = protocolVersion;
        try {
            String s = protocolVersion.v >= ProtocolVersion.TLS12.v ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator kg = JsseJce.getKeyGenerator(s);
            kg.init(new TlsRsaPremasterSecretParameterSpec(maxVersion.v, protocolVersion.v), generator);
            this.preMaster = kg.generateKey();
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(3, (Key)publicKey, generator);
            this.encrypted = cipher.wrap(this.preMaster);
        }
        catch (GeneralSecurityException e) {
            throw (SSLKeyException)new SSLKeyException("RSA premaster secret error").initCause(e);
        }
    }

    private static String safeProviderName(Cipher cipher) {
        try {
            return cipher.getProvider().toString();
        }
        catch (Exception e) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Retrieving The Cipher provider name caused exception " + e.getMessage());
            }
            try {
                return ((Object)cipher).toString() + " (provider name not available)";
            }
            catch (Exception e2) {
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Retrieving The Cipher name caused exception " + e2.getMessage());
                }
                return "(cipher/provider names not available)";
            }
        }
    }

    RSAClientKeyExchange(ProtocolVersion currentVersion, ProtocolVersion maxVersion, SecureRandom generator, HandshakeInStream input, int messageSize, PrivateKey privateKey) throws IOException {
        block14: {
            if (!privateKey.getAlgorithm().equals("RSA")) {
                throw new SSLKeyException("Private key not of type RSA: " + privateKey.getAlgorithm());
            }
            if (currentVersion.v >= ProtocolVersion.TLS10.v) {
                this.encrypted = input.getBytes16();
            } else {
                this.encrypted = new byte[messageSize];
                if (input.read(this.encrypted) != messageSize) {
                    throw new SSLProtocolException("SSL: read PreMasterSecret: short read");
                }
            }
            byte[] encoded = null;
            try {
                boolean needFailover = false;
                Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
                try {
                    cipher.init(4, (Key)privateKey, new TlsRsaPremasterSecretParameterSpec(maxVersion.v, currentVersion.v), generator);
                    needFailover = !KeyUtil.isOracleJCEProvider(cipher.getProvider().getName());
                }
                catch (UnsupportedOperationException | InvalidKeyException iue) {
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("The Cipher provider " + RSAClientKeyExchange.safeProviderName(cipher) + " caused exception: " + iue.getMessage());
                    }
                    needFailover = true;
                }
                if (needFailover) {
                    cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
                    cipher.init(2, privateKey);
                    boolean failed = false;
                    try {
                        encoded = cipher.doFinal(this.encrypted);
                    }
                    catch (BadPaddingException bpe) {
                        failed = true;
                    }
                    encoded = KeyUtil.checkTlsPreMasterSecretKey(maxVersion.v, currentVersion.v, generator, encoded, failed);
                    this.preMaster = RSAClientKeyExchange.generatePreMasterSecret(maxVersion.v, currentVersion.v, encoded, generator);
                    break block14;
                }
                this.preMaster = (SecretKey)cipher.unwrap(this.encrypted, "TlsRsaPremasterSecret", 3);
            }
            catch (InvalidKeyException ibk) {
                throw new SSLException("Unable to process PreMasterSecret", ibk);
            }
            catch (Exception e) {
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("RSA premaster secret decryption error:");
                    e.printStackTrace(System.out);
                }
                throw new RuntimeException("Could not generate dummy secret", e);
            }
        }
    }

    private static SecretKey generatePreMasterSecret(int clientVersion, int serverVersion, byte[] encodedSecret, SecureRandom generator) {
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("Generating a premaster secret");
        }
        try {
            String s = clientVersion >= ProtocolVersion.TLS12.v ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator kg = JsseJce.getKeyGenerator(s);
            kg.init(new TlsRsaPremasterSecretParameterSpec(clientVersion, serverVersion, encodedSecret), generator);
            return kg.generateKey();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException iae) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA premaster secret generation error:");
                iae.printStackTrace(System.out);
            }
            throw new RuntimeException("Could not generate premaster secret", iae);
        }
    }

    @Override
    int messageType() {
        return 16;
    }

    @Override
    int messageLength() {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            return this.encrypted.length + 2;
        }
        return this.encrypted.length;
    }

    @Override
    void send(HandshakeOutStream s) throws IOException {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            s.putBytes16(this.encrypted);
        } else {
            s.write(this.encrypted);
        }
    }

    @Override
    void print(PrintStream s) throws IOException {
        String version = "version not available/extractable";
        byte[] ba = this.preMaster.getEncoded();
        if (ba != null && ba.length >= 2) {
            version = ProtocolVersion.valueOf((int)ba[0], (int)ba[1]).name;
        }
        s.println("*** ClientKeyExchange, RSA PreMasterSecret, " + version);
    }
}

