/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.com.fasterxml.jackson.annotation.JsonCreator;
import com.azul.crs.com.fasterxml.jackson.annotation.JsonProperty;
import com.azul.crs.shared.models.Payload;
import java.util.Objects;

public class ComponentUsage
extends Payload {
    private final String name;
    private final Integer version;
    private final Integer likehood;

    @JsonCreator
    public ComponentUsage(@JsonProperty(value="name") String name, @JsonProperty(value="version") Integer version, @JsonProperty(value="likehood") Integer likehood) {
        this.name = name;
        this.version = version;
        this.likehood = likehood;
    }

    public String getName() {
        return this.name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getLikehood() {
        return this.likehood;
    }

    public Builder copier() {
        return new Builder().name(this.name).version(this.version).likehood(this.likehood);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ComponentUsage lib) {
        return new Builder().name(lib.name).version(lib.version).likehood(lib.likehood);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentUsage that = (ComponentUsage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.likehood, that.likehood);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.likehood);
    }

    public static class Builder {
        private String name;
        private Integer version;
        private Integer likehood;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder likehood(Integer likehood) {
            this.likehood = likehood;
            return this;
        }

        public ComponentUsage build() {
            return new ComponentUsage(this.name, this.version, this.likehood);
        }
    }
}

