/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Client;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

enum Options {
    props,
    lifetimejfr,
    stackRecordId,
    useCRS,
    forceSyncTimeout,
    noDelayShutdown,
    delayShutdown;

    private static final String DEFAULT_SHARED_PROPS_FILE = "crs.properties";
    private static final String DEFAULT_USER_PROPS_FILE;
    private String value;
    private static Map<Client.ClientProp, Object> clientProps;
    private static LinkedList<Map.Entry<String, String>> loggerOptions;

    String get() {
        return this.value;
    }

    boolean isSet() {
        return this.value != null;
    }

    int getInt() {
        return Integer.parseInt(this.value);
    }

    long getLong() {
        return Long.parseLong(this.value);
    }

    private void set(String value) {
        this.value = value;
    }

    static void read(String commandLineArgs) {
        File propsFile;
        loggerOptions = new LinkedList();
        String envArgs = System.getenv("CRS_ARGUMENTS");
        String explicitPropsFile = Options.getPropFileNameFromArgs(commandLineArgs);
        if (explicitPropsFile == null) {
            explicitPropsFile = Options.getPropFileNameFromArgs(envArgs);
        }
        if (explicitPropsFile != null) {
            propsFile = new File(explicitPropsFile);
            if (!propsFile.exists()) {
                Logger.getLogger(Options.class).error("specified properties file %s does not exist", propsFile.getPath());
            }
        } else {
            propsFile = new File(System.getProperty("user.home") + File.separatorChar + DEFAULT_USER_PROPS_FILE);
            if (!propsFile.exists()) {
                propsFile = new File(System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + DEFAULT_SHARED_PROPS_FILE);
            }
        }
        if (propsFile.exists()) {
            Options.tryLoadingProps(propsFile);
        }
        Options.readArgs(envArgs);
        Options.readArgs(commandLineArgs);
        for (Map.Entry entry : loggerOptions) {
            Logger.parseOption((String)entry.getKey(), (String)entry.getValue());
        }
        loggerOptions = null;
    }

    private static String getPropFileNameFromArgs(String args) {
        String propsFile = null;
        if (args != null && args.length() > 0) {
            int ePos;
            int cPos = args.indexOf(44);
            if (cPos < 0) {
                cPos = args.length();
            }
            if (args.charAt(0) != ',' && ((ePos = args.indexOf(61)) < 0 || ePos > cPos)) {
                try {
                    Options.valueOf(args.substring(0, cPos));
                }
                catch (IllegalArgumentException theArgumentIsNotAnOptionName) {
                    propsFile = args.substring(0, cPos);
                }
            }
            int sPos = 0;
            String propsName = props.name() + "=";
            int propsNameLength = propsName.length();
            do {
                if ((cPos = args.indexOf(44, sPos)) < 0) {
                    cPos = args.length();
                }
                if (!args.startsWith(propsName, sPos)) continue;
                propsFile = args.substring(sPos + propsNameLength, cPos);
                break;
            } while ((sPos = cPos + 1) < args.length());
        }
        return propsFile;
    }

    private static void readArgs(String args) {
        int cPos;
        if (args == null) {
            return;
        }
        int sPos = 0;
        do {
            String value;
            int ePos;
            if ((cPos = args.indexOf(44, sPos)) == -1) {
                cPos = args.length();
            }
            if ((ePos = args.indexOf(61, sPos)) == -1 || ePos > cPos) {
                ePos = cPos;
            }
            String name = args.substring(sPos, ePos);
            String string = value = ePos == cPos ? "" : args.substring(ePos + 1, cPos);
            if (props.name().equals(name)) continue;
            Options.process(name, value, sPos == 0 && ePos == cPos);
        } while ((sPos = cPos + 1) < args.length());
    }

    private static void process(String name, String value, boolean ignoreMaybePropsFile) {
        block8: {
            if (name.equals("log") || name.startsWith("log+")) {
                loggerOptions.add(new AbstractMap.SimpleEntry<String, String>(name, value));
            } else if (props.name().equals(name)) {
                Options.tryLoadingProps(new File(value));
            } else if (name.length() > 0) {
                for (Client.ClientProp p : (Client.ClientProp[])Client.ClientProp.class.getEnumConstants()) {
                    if (!p.value().equals(name)) continue;
                    clientProps.put(p, value);
                    return;
                }
                try {
                    Options.valueOf(name).set(value);
                }
                catch (IllegalArgumentException iae) {
                    if (ignoreMaybePropsFile) break block8;
                    Logger.getLogger(Options.class).error("unrecognized CRS agent option %s ignored", name);
                }
            }
        }
    }

    private static void tryLoadingProps(File file) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(file));
            for (String name : props.stringPropertyNames()) {
                Options.process(name, props.getProperty(name), false);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Options.class).error("cannot load specified properties file %s: %s", file.getPath(), ex.getMessage());
        }
    }

    public static Map<Client.ClientProp, Object> getClientProps() {
        return clientProps;
    }

    static {
        DEFAULT_USER_PROPS_FILE = ".crs" + File.separatorChar + "config.properties";
        clientProps = new HashMap<Client.ClientProp, Object>();
    }
}

