/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.Extension;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.misc.CharacterEncoder;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.ResponderId;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CertImpl;

public final class OCSPResponse {
    private static final ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump = debug != null && Debug.isOn("ocsp");
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private static final int DEFAULT_MAX_CLOCK_SKEW = 900000;
    private static final int MAX_CLOCK_SKEW = OCSPResponse.initializeClockSkew();
    private static final CRLReason[] values = CRLReason.values();
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private final AlgorithmId sigAlgId;
    private final byte[] signature;
    private final byte[] tbsResponseData;
    private final byte[] responseNonce;
    private List<X509CertImpl> certs;
    private X509CertImpl signerCert = null;
    private final ResponderId respId;
    private Date producedAtDate = null;
    private final Map<String, Extension> responseExtensions;

    private static int initializeClockSkew() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.clockSkew"));
        if (n == null || n < 0) {
            return 900000;
        }
        return n * 1000;
    }

    public OCSPResponse(byte[] byArray) throws IOException {
        Object object;
        if (dump) {
            object = new HexDumpEncoder();
            debug.println("OCSPResponse bytes...\n\n" + ((CharacterEncoder)object).encode(byArray) + "\n");
        }
        object = new DerValue(byArray);
        if (((DerValue)object).tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream = ((DerValue)object).getData();
        int n = derInputStream.getEnumerated();
        if (n < 0 || n >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + n);
        }
        this.responseStatus = rsvalues[n];
        if (debug != null) {
            debug.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            this.certs = new ArrayList<X509CertImpl>();
            this.sigAlgId = null;
            this.signature = null;
            this.tbsResponseData = null;
            this.responseNonce = null;
            this.responseExtensions = Collections.emptyMap();
            this.respId = null;
            return;
        }
        object = derInputStream.getDerValue();
        if (!((DerValue)object).isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue derValue = ((DerValue)object).data.getDerValue();
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derInputStream = derValue.data;
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (objectIdentifier.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            if (debug != null) {
                debug.println("OCSP response type: basic");
            }
        } else {
            if (debug != null) {
                debug.println("OCSP response type: " + objectIdentifier);
            }
            throw new IOException("Unsupported OCSP response type: " + objectIdentifier);
        }
        DerInputStream derInputStream2 = new DerInputStream(derInputStream.getOctetString());
        DerValue[] derValueArray = derInputStream2.getSequence(3);
        if (derValueArray.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue derValue2 = derValueArray[0];
        this.tbsResponseData = derValueArray[0].toByteArray();
        if (derValue2.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream3 = derValue2.data;
        DerValue derValue3 = derInputStream3.getDerValue();
        if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed() && derValue3.isContextSpecific()) {
            derValue3 = derValue3.data.getDerValue();
            int n2 = derValue3.getInteger();
            if (derValue3.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            derValue3 = derInputStream3.getDerValue();
        }
        this.respId = new ResponderId(derValue3.toByteArray());
        if (debug != null) {
            debug.println("Responder ID: " + this.respId);
        }
        derValue3 = derInputStream3.getDerValue();
        this.producedAtDate = derValue3.getGeneralizedTime();
        if (debug != null) {
            debug.println("OCSP response produced at: " + this.producedAtDate);
        }
        DerValue[] derValueArray2 = derInputStream3.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(derValueArray2.length);
        if (debug != null) {
            debug.println("OCSP number of SingleResponses: " + derValueArray2.length);
        }
        for (DerValue derValueArray3 : derValueArray2) {
            SingleResponse i = new SingleResponse(derValueArray3);
            this.singleResponseMap.put(i.getCertId(), i);
        }
        Object object2 = new HashMap();
        if (derInputStream3.available() > 0 && (derValue3 = derInputStream3.getDerValue()).isContextSpecific((byte)1)) {
            object2 = OCSPResponse.parseExtensions(derValue3);
        }
        this.responseExtensions = object2;
        sun.security.x509.Extension extension = (sun.security.x509.Extension)object2.get(PKIXExtensions.OCSPNonce_Id.toString());
        byte[] byArray2 = this.responseNonce = extension != null ? extension.getExtensionValue() : null;
        if (debug != null && this.responseNonce != null) {
            debug.println("Response nonce: " + Arrays.toString(this.responseNonce));
        }
        this.sigAlgId = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (derValueArray.length > 3) {
            DerValue derValue4 = derValueArray[3];
            if (!derValue4.isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            DerValue[] derValueArray3 = derValue4.getData().getSequence(3);
            this.certs = new ArrayList<X509CertImpl>(derValueArray3.length);
            try {
                for (int certificateException = 0; certificateException < derValueArray3.length; ++certificateException) {
                    X509CertImpl x509CertImpl = new X509CertImpl(derValueArray3[certificateException].toByteArray());
                    this.certs.add(x509CertImpl);
                    if (debug == null) continue;
                    debug.println("OCSP response cert #" + (certificateException + 1) + ": " + x509CertImpl.getSubjectX500Principal());
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException("Bad encoding in X509 Certificate", certificateException);
            }
        } else {
            this.certs = Collections.emptyList();
        }
    }

    void verify(List<CertId> list, IssuerInfo issuerInfo, X509Certificate x509Certificate, Date date, byte[] byArray, String string) throws CertPathValidatorException {
        Object object;
        Object object2;
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)this.responseStatus));
        }
        for (CertId object4 : list) {
            SingleResponse singleResponse = this.getSingleResponse(object4);
            if (singleResponse == null) {
                if (debug != null) {
                    debug.println("No response found for CertId: " + object4);
                }
                throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
            }
            if (debug == null) continue;
            debug.println("Status of certificate (with serial number " + object4.getSerialNumber() + ") is: " + (Object)((Object)singleResponse.getCertStatus()));
        }
        if (this.signerCert == null) {
            try {
                if (issuerInfo.getCertificate() != null) {
                    this.certs.add(X509CertImpl.toImpl(issuerInfo.getCertificate()));
                }
                if (x509Certificate != null) {
                    this.certs.add(X509CertImpl.toImpl(x509Certificate));
                }
            }
            catch (CertificateException certificateException) {
                throw new CertPathValidatorException("Invalid issuer or trusted responder certificate", certificateException);
            }
            if (this.respId.getType() == ResponderId.Type.BY_NAME) {
                object2 = this.respId.getResponderName();
                for (X509CertImpl x509CertImpl : this.certs) {
                    if (!x509CertImpl.getSubjectX500Principal().equals(object2)) continue;
                    this.signerCert = x509CertImpl;
                    break;
                }
            } else if (this.respId.getType() == ResponderId.Type.BY_KEY) {
                object2 = this.respId.getKeyIdentifier();
                for (X509CertImpl x509CertImpl : this.certs) {
                    object = x509CertImpl.getSubjectKeyId();
                    if (object != null && ((KeyIdentifier)object2).equals(object)) {
                        this.signerCert = x509CertImpl;
                        break;
                    }
                    try {
                        object = new KeyIdentifier(x509CertImpl.getPublicKey());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!((KeyIdentifier)object2).equals(object)) continue;
                    this.signerCert = x509CertImpl;
                    break;
                }
            }
        }
        if (this.signerCert != null) {
            if (this.signerCert.getSubjectX500Principal().equals(issuerInfo.getName()) && this.signerCert.getPublicKey().equals(issuerInfo.getPublicKey())) {
                if (debug != null) {
                    debug.println("OCSP response is signed by the target's Issuing CA");
                }
            } else if (this.signerCert.equals(x509Certificate)) {
                if (debug != null) {
                    debug.println("OCSP response is signed by a Trusted Responder");
                }
            } else if (this.signerCert.getIssuerX500Principal().equals(issuerInfo.getName())) {
                try {
                    object2 = this.signerCert.getExtendedKeyUsage();
                    if (object2 == null || !object2.contains(KP_OCSP_SIGNING_OID)) {
                        throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                    }
                }
                catch (CertificateParsingException certificateParsingException) {
                    throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses", certificateParsingException);
                }
                object2 = new AlgorithmChecker(issuerInfo.getAnchor(), date, string);
                ((AlgorithmChecker)object2).init(false);
                ((AlgorithmChecker)object2).check(this.signerCert, Collections.emptySet());
                try {
                    if (date == null) {
                        this.signerCert.checkValidity();
                    } else {
                        this.signerCert.checkValidity(date);
                    }
                }
                catch (CertificateException certificateException) {
                    throw new CertPathValidatorException("Responder's certificate not within the validity period", certificateException);
                }
                sun.security.x509.Extension extension = this.signerCert.getExtension(PKIXExtensions.OCSPNoCheck_Id);
                if (extension != null && debug != null) {
                    debug.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                }
                try {
                    this.signerCert.verify(issuerInfo.getPublicKey());
                    if (debug != null) {
                        debug.println("OCSP response is signed by an Authorized Responder");
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    this.signerCert = null;
                }
            } else {
                throw new CertPathValidatorException("Responder's certificate is not authorized to sign OCSP responses");
            }
        }
        if (this.signerCert != null) {
            AlgorithmChecker.check(this.signerCert.getPublicKey(), this.sigAlgId, string);
            if (!this.verifySignature(this.signerCert)) {
                throw new CertPathValidatorException("Error verifying OCSP Response's signature");
            }
        } else {
            throw new CertPathValidatorException("Unable to verify OCSP Response's signature");
        }
        if (byArray != null && this.responseNonce != null && !Arrays.equals(byArray, this.responseNonce)) {
            throw new CertPathValidatorException("Nonces don't match");
        }
        long l = date == null ? System.currentTimeMillis() : date.getTime();
        Date date2 = new Date(l + (long)MAX_CLOCK_SKEW);
        object = new Date(l - (long)MAX_CLOCK_SKEW);
        for (SingleResponse singleResponse : this.singleResponseMap.values()) {
            if (debug != null) {
                String string2 = "";
                if (singleResponse.nextUpdate != null) {
                    string2 = " until " + singleResponse.nextUpdate;
                }
                debug.println("OCSP response validity interval is from " + singleResponse.thisUpdate + string2);
                debug.println("Checking validity of OCSP response on: " + new Date(l));
            }
            if (!date2.before(singleResponse.thisUpdate) && !((Date)object).after(singleResponse.nextUpdate != null ? singleResponse.nextUpdate : singleResponse.thisUpdate)) continue;
            throw new CertPathValidatorException("Response is unreliable: its validity interval is out-of-date");
        }
    }

    public ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifySignature(X509Certificate x509Certificate) throws CertPathValidatorException {
        try {
            Signature signature = Signature.getInstance(this.sigAlgId.getName());
            signature.initVerify(x509Certificate.getPublicKey());
            signature.update(this.tbsResponseData);
            if (signature.verify(this.signature)) {
                if (debug != null) {
                    debug.println("Verified signature of OCSP Response");
                }
                return true;
            }
            if (debug != null) {
                debug.println("Error verifying signature of OCSP Response");
            }
            return false;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            throw new CertPathValidatorException(generalSecurityException);
        }
    }

    public SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    public Set<CertId> getCertIds() {
        return Collections.unmodifiableSet(this.singleResponseMap.keySet());
    }

    X509Certificate getSignerCertificate() {
        return this.signerCert;
    }

    public ResponderId getResponderId() {
        return this.respId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCSP Response:\n");
        stringBuilder.append("Response Status: ").append((Object)this.responseStatus).append("\n");
        stringBuilder.append("Responder ID: ").append(this.respId).append("\n");
        stringBuilder.append("Produced at: ").append(this.producedAtDate).append("\n");
        int n = this.singleResponseMap.size();
        stringBuilder.append(n).append(n == 1 ? " response:\n" : " responses:\n");
        for (SingleResponse object : this.singleResponseMap.values()) {
            stringBuilder.append(object).append("\n");
        }
        if (this.responseExtensions != null && this.responseExtensions.size() > 0) {
            n = this.responseExtensions.size();
            stringBuilder.append(n).append(n == 1 ? " extension:\n" : " extensions:\n");
            for (String string : this.responseExtensions.keySet()) {
                stringBuilder.append(this.responseExtensions.get(string)).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    private static Map<String, Extension> parseExtensions(DerValue derValue) throws IOException {
        DerValue[] derValueArray = derValue.data.getSequence(3);
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>(derValueArray.length);
        for (DerValue derValue2 : derValueArray) {
            sun.security.x509.Extension extension = new sun.security.x509.Extension(derValue2);
            if (debug != null) {
                debug.println("Extension: " + extension);
            }
            if (extension.isCritical()) {
                throw new IOException("Unsupported OCSP critical extension: " + extension.getExtensionId());
            }
            hashMap.put(extension.getId(), extension);
        }
        return hashMap;
    }

    static final class IssuerInfo {
        private final TrustAnchor anchor;
        private final X509Certificate certificate;
        private final X500Principal name;
        private final PublicKey pubKey;

        IssuerInfo(TrustAnchor trustAnchor) {
            this(trustAnchor, trustAnchor != null ? trustAnchor.getTrustedCert() : null);
        }

        IssuerInfo(X509Certificate x509Certificate) {
            this(null, x509Certificate);
        }

        IssuerInfo(TrustAnchor trustAnchor, X509Certificate x509Certificate) {
            if (trustAnchor == null && x509Certificate == null) {
                throw new NullPointerException("TrustAnchor and issuerCert cannot be null");
            }
            this.anchor = trustAnchor;
            if (x509Certificate != null) {
                this.name = x509Certificate.getSubjectX500Principal();
                this.pubKey = x509Certificate.getPublicKey();
                this.certificate = x509Certificate;
            } else {
                this.name = trustAnchor.getCA();
                this.pubKey = trustAnchor.getCAPublicKey();
                this.certificate = trustAnchor.getTrustedCert();
            }
        }

        X509Certificate getCertificate() {
            return this.certificate;
        }

        X500Principal getName() {
            return this.name;
        }

        PublicKey getPublicKey() {
            return this.pubKey;
        }

        TrustAnchor getAnchor() {
            return this.anchor;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Issuer Info:\n");
            stringBuilder.append("Name: ").append(this.name.toString()).append("\n");
            stringBuilder.append("Public Key:\n").append(this.pubKey.toString()).append("\n");
            return stringBuilder.toString();
        }
    }

    public static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private final CRLReason revocationReason;
        private final Map<String, Extension> singleExtensions;

        private SingleResponse(DerValue derValue) throws IOException {
            this(derValue, (Date)null);
        }

        private SingleResponse(DerValue derValue, Date date) throws IOException {
            Object object;
            if (derValue.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream derInputStream = derValue.data;
            this.certId = new CertId(derInputStream.getDerValue().data);
            DerValue derValue2 = derInputStream.getDerValue();
            short s = (byte)(derValue2.tag & 0x1F);
            if (s == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derValue2.data.getGeneralizedTime();
                if (derValue2.data.available() != 0) {
                    int n;
                    object = derValue2.data.getDerValue();
                    s = (byte)(((DerValue)object).tag & 0x1F);
                    this.revocationReason = s == 0 ? ((n = ((DerValue)object).data.getEnumerated()) >= 0 && n < values.length ? values[n] : CRLReason.UNSPECIFIED) : CRLReason.UNSPECIFIED;
                } else {
                    this.revocationReason = CRLReason.UNSPECIFIED;
                }
                if (debug != null) {
                    debug.println("Revocation time: " + this.revocationTime);
                    debug.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = null;
                if (s == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (s == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = derInputStream.getGeneralizedTime();
            if (debug != null) {
                debug.println("thisUpdate: " + this.thisUpdate);
            }
            object = null;
            Map map = null;
            if (derInputStream.available() > 0) {
                derValue2 = derInputStream.getDerValue();
                if (derValue2.isContextSpecific((byte)0)) {
                    object = derValue2.data.getGeneralizedTime();
                    if (debug != null) {
                        debug.println("nextUpdate: " + object);
                    }
                    DerValue derValue3 = derValue2 = derInputStream.available() > 0 ? derInputStream.getDerValue() : null;
                }
                if (derValue2 != null) {
                    if (derValue2.isContextSpecific((byte)1)) {
                        map = OCSPResponse.parseExtensions(derValue2);
                        if (derInputStream.available() > 0) {
                            throw new IOException(derInputStream.available() + " bytes of additional data in singleResponse");
                        }
                    } else {
                        throw new IOException("Unsupported singleResponse item, tag = " + String.format("%02X", derValue2.tag));
                    }
                }
            }
            this.nextUpdate = object;
            Map<String, Extension> map2 = this.singleExtensions = map != null ? map : Collections.emptyMap();
            if (debug != null) {
                for (Extension extension : this.singleExtensions.values()) {
                    debug.println("singleExtension: " + extension);
                }
            }
        }

        @Override
        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        public CertId getCertId() {
            return this.certId;
        }

        public Date getThisUpdate() {
            return this.thisUpdate != null ? (Date)this.thisUpdate.clone() : null;
        }

        public Date getNextUpdate() {
            return this.nextUpdate != null ? (Date)this.nextUpdate.clone() : null;
        }

        @Override
        public Date getRevocationTime() {
            return this.revocationTime != null ? (Date)this.revocationTime.clone() : null;
        }

        @Override
        public CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public Map<String, Extension> getSingleExtensions() {
            return Collections.unmodifiableMap(this.singleExtensions);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SingleResponse:\n");
            stringBuilder.append(this.certId);
            stringBuilder.append("\nCertStatus: ").append((Object)this.certStatus).append("\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                stringBuilder.append("revocationTime is ");
                stringBuilder.append(this.revocationTime).append("\n");
                stringBuilder.append("revocationReason is ");
                stringBuilder.append((Object)this.revocationReason).append("\n");
            }
            stringBuilder.append("thisUpdate is ").append(this.thisUpdate).append("\n");
            if (this.nextUpdate != null) {
                stringBuilder.append("nextUpdate is ").append(this.nextUpdate).append("\n");
            }
            for (Extension extension : this.singleExtensions.values()) {
                stringBuilder.append("singleExtension: ");
                stringBuilder.append(extension.toString()).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

