/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.util.KerberosFlags;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class KDCOptions
extends KerberosFlags {
    public final int KDC_OPT_PROXIABLE = 0x10000000;
    public final int KDC_OPT_RENEWABLE_OK = 16;
    public final int KDC_OPT_FORWARDABLE = 0x40000000;
    public static final int RESERVED = 0;
    public static final int FORWARDABLE = 1;
    public static final int FORWARDED = 2;
    public static final int PROXIABLE = 3;
    public static final int PROXY = 4;
    public static final int ALLOW_POSTDATE = 5;
    public static final int POSTDATED = 6;
    public static final int UNUSED7 = 7;
    public static final int RENEWABLE = 8;
    public static final int UNUSED9 = 9;
    public static final int UNUSED10 = 10;
    public static final int UNUSED11 = 11;
    public static final int RENEWABLE_OK = 27;
    public static final int ENC_TKT_IN_SKEY = 28;
    public static final int RENEW = 30;
    public static final int VALIDATE = 31;
    private boolean DEBUG = Krb5.DEBUG;

    public KDCOptions() {
        super(32);
        this.setDefault();
    }

    public KDCOptions(int n, byte[] byArray) throws Asn1Exception {
        super(n, byArray);
        if (n > byArray.length * 8 || n > 32) {
            throw new Asn1Exception(502);
        }
    }

    public KDCOptions(boolean[] blArray) throws Asn1Exception {
        super(blArray);
        if (blArray.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public KDCOptions(DerValue derValue) throws Asn1Exception, IOException {
        this(derValue.getUnalignedBitString(true).toBooleanArray());
    }

    public KDCOptions(byte[] byArray) {
        super(byArray.length * 8, byArray);
    }

    public static KDCOptions parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new KDCOptions(derValue2);
    }

    @Override
    public void set(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        super.set(n, bl);
    }

    @Override
    public boolean get(int n) throws ArrayIndexOutOfBoundsException {
        return super.get(n);
    }

    private void setDefault() {
        block11: {
            try {
                Config config = Config.getInstance();
                int n = config.getIntValue("libdefaults", "kdc_default_options");
                if ((n & 0x1B) == 27) {
                    this.set(27, true);
                } else if (config.getBooleanValue("libdefaults", "renewable")) {
                    this.set(27, true);
                }
                if ((n & 3) == 3) {
                    this.set(3, true);
                } else if (config.getBooleanValue("libdefaults", "proxiable")) {
                    this.set(3, true);
                }
                if ((n & 1) == 1) {
                    this.set(1, true);
                } else if (config.getBooleanValue("libdefaults", "forwardable")) {
                    this.set(1, true);
                }
            }
            catch (KrbException krbException) {
                if (!this.DEBUG) break block11;
                System.out.println("Exception in getting default values for KDC Options from the configuration ");
                krbException.printStackTrace();
            }
        }
    }
}

