/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Image;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.awt.SunToolkit;
import sun.lwawt.LWToolkit;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CMenuComponent;
import sun.lwawt.macosx.CThreading;

public class CMenuItem
extends CMenuComponent
implements MenuItemPeer {
    private final AtomicBoolean enabled = new AtomicBoolean(true);

    public CMenuItem(MenuItem menuItem) {
        super(menuItem);
        this.initialize(menuItem);
    }

    protected void initialize(MenuItem menuItem) {
        if (!this.isSeparator()) {
            this.setLabel(menuItem.getLabel());
            this.setEnabled(menuItem.isEnabled());
        }
    }

    private boolean isSeparator() {
        String string = ((MenuItem)this.getTarget()).getLabel();
        return string != null && string.equals("-");
    }

    @Override
    long createModel() {
        CMenuComponent cMenuComponent = (CMenuComponent)LWToolkit.targetToPeer(this.getTarget().getParent());
        return cMenuComponent.executeGet(new CFRetainedResource.CFNativeActionGet(){

            @Override
            public long run(long l) {
                return CMenuItem.this.nativeCreate(l, CMenuItem.this.isSeparator());
            }
        });
    }

    public void setLabel(String string, char c, int n, int n2) {
        Object object;
        int n3 = n2;
        if (n == 0 && (object = ((MenuItem)this.getTarget()).getShortcut()) != null) {
            n = ((MenuShortcut)object).getKey();
            n3 |= 4;
            if (((MenuShortcut)object).usesShiftModifier()) {
                n3 |= 1;
            }
        }
        if (string == null) {
            string = "";
        }
        if (c == '\uffff') {
            c = '\u0000';
        }
        object = string;
        char c2 = c;
        int n4 = n;
        int n5 = n3;
        this.execute(new CFRetainedResource.CFNativeAction((String)object, c2, n4, n5){
            final /* synthetic */ String val$finalLabel;
            final /* synthetic */ char val$finalKeyChar;
            final /* synthetic */ int val$finalKeyCode;
            final /* synthetic */ int val$finalKeyMask;
            {
                this.val$finalLabel = string;
                this.val$finalKeyChar = c;
                this.val$finalKeyCode = n;
                this.val$finalKeyMask = n2;
            }

            @Override
            public void run(long l) {
                CMenuItem.this.nativeSetLabel(l, this.val$finalLabel, this.val$finalKeyChar, this.val$finalKeyCode, this.val$finalKeyMask);
            }
        });
    }

    @Override
    public void setLabel(String string) {
        this.setLabel(string, '\u0000', 0, 0);
    }

    public final void setImage(Image image) {
        final CImage cImage = CImage.getCreator().createFromImage(image);
        this.execute(new CFRetainedResource.CFNativeAction(){

            @Override
            public void run(final long l) {
                if (cImage == null) {
                    CMenuItem.this.nativeSetImage(l, 0L);
                } else {
                    cImage.execute(new CFRetainedResource.CFNativeAction(){

                        @Override
                        public void run(long l2) {
                            CMenuItem.this.nativeSetImage(l, l2);
                        }
                    });
                }
            }
        });
    }

    public final void setToolTipText(final String string) {
        this.execute(new CFRetainedResource.CFNativeAction(){

            @Override
            public void run(long l) {
                CMenuItem.this.nativeSetTooltip(l, string);
            }
        });
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public final boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public void setEnabled(boolean bl) {
        Object object = LWToolkit.targetToPeer(this.getTarget().getParent());
        if (object instanceof CMenuItem) {
            bl &= ((CMenuItem)object).isEnabled();
        }
        if (this.enabled.compareAndSet(!bl, bl)) {
            final boolean bl2 = bl;
            this.execute(new CFRetainedResource.CFNativeAction(){

                @Override
                public void run(long l) {
                    CMenuItem.this.nativeSetEnabled(l, bl2);
                }
            });
        }
    }

    private native long nativeCreate(long var1, boolean var3);

    private native void nativeSetLabel(long var1, String var3, char var4, int var5, int var6);

    private native void nativeSetImage(long var1, long var3);

    private native void nativeSetTooltip(long var1, String var3);

    private native void nativeSetEnabled(long var1, boolean var3);

    void handleAction(final long l, final int n) {
        assert (CThreading.assertAppKit());
        SunToolkit.executeOnEventHandlerThread(this.getTarget(), new Runnable(){

            @Override
            public void run() {
                String string = ((MenuItem)CMenuItem.this.getTarget()).getActionCommand();
                ActionEvent actionEvent = new ActionEvent(CMenuItem.this.getTarget(), 1001, string, l, n);
                SunToolkit.postEvent(SunToolkit.targetToAppContext(CMenuItem.this.getTarget()), actionEvent);
            }
        });
    }
}

