/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import sun.misc.IoTrace;
import sun.net.ConnectionResetException;

class SocketInputStream
extends FileInputStream {
    private boolean eof;
    private AbstractPlainSocketImpl impl = null;
    private byte[] temp;
    private Socket socket = null;
    private boolean closing = false;

    SocketInputStream(AbstractPlainSocketImpl abstractPlainSocketImpl) throws IOException {
        super(abstractPlainSocketImpl.getFileDescriptor());
        this.impl = abstractPlainSocketImpl;
        this.socket = abstractPlainSocketImpl.getSocket();
    }

    @Override
    public final FileChannel getChannel() {
        return null;
    }

    private native int socketRead0(FileDescriptor var1, byte[] var2, int var3, int var4, int var5) throws IOException;

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, n2, this.impl.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int read(byte[] byArray, int n, int n2, int n3) throws IOException {
        FileDescriptor fileDescriptor;
        Object object;
        boolean bl;
        int n4;
        block16: {
            int n5;
            n4 = 0;
            if (this.eof) {
                return -1;
            }
            if (this.impl.isConnectionReset()) {
                throw new SocketException("Connection reset");
            }
            if (n2 <= 0 || n < 0 || n2 > byArray.length - n) {
                if (n2 == 0) {
                    return 0;
                }
                throw new ArrayIndexOutOfBoundsException("length == " + n2 + " off == " + n + " buffer length == " + byArray.length);
            }
            bl = false;
            object = IoTrace.socketReadBegin();
            fileDescriptor = this.impl.acquireFD();
            try {
                n4 = this.socketRead0(fileDescriptor, byArray, n, n2, n3);
                if (n4 <= 0) break block16;
                n5 = n4;
                this.impl.releaseFD();
                IoTrace.socketReadEnd(object, this.impl.address, this.impl.port, n3, n4 > 0 ? (long)n4 : 0L);
            }
            catch (ConnectionResetException connectionResetException) {
                try {
                    bl = true;
                    this.impl.releaseFD();
                    IoTrace.socketReadEnd(object, this.impl.address, this.impl.port, n3, n4 > 0 ? (long)n4 : 0L);
                }
                catch (Throwable throwable) {
                    this.impl.releaseFD();
                    IoTrace.socketReadEnd(object, this.impl.address, this.impl.port, n3, n4 > 0 ? (long)n4 : 0L);
                    throw throwable;
                }
            }
            return n5;
        }
        this.impl.releaseFD();
        IoTrace.socketReadEnd(object, this.impl.address, this.impl.port, n3, n4 > 0 ? (long)n4 : 0L);
        if (bl) {
            block17: {
                int n6;
                object = IoTrace.socketReadBegin();
                this.impl.setConnectionResetPending();
                this.impl.acquireFD();
                try {
                    n4 = this.socketRead0(fileDescriptor, byArray, n, n2, n3);
                    if (n4 <= 0) break block17;
                    n6 = n4;
                    this.impl.releaseFD();
                    IoTrace.socketReadEnd(object, this.impl.address, this.impl.port, n3, n4 > 0 ? (long)n4 : 0L);
                }
                catch (ConnectionResetException connectionResetException) {
                    this.impl.releaseFD();
                    IoTrace.socketReadEnd(object, this.impl.address, this.impl.port, n3, n4 > 0 ? (long)n4 : 0L);
                    catch (Throwable throwable) {
                        this.impl.releaseFD();
                        IoTrace.socketReadEnd(object, this.impl.address, this.impl.port, n3, n4 > 0 ? (long)n4 : 0L);
                        throw throwable;
                    }
                }
                return n6;
            }
            this.impl.releaseFD();
            IoTrace.socketReadEnd(object, this.impl.address, this.impl.port, n3, n4 > 0 ? (long)n4 : 0L);
        }
        if (this.impl.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        if (this.impl.isConnectionResetPending()) {
            this.impl.setConnectionReset();
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("Connection reset");
        }
        this.eof = true;
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.temp = new byte[1];
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        long l2;
        if (l <= 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(1024L, l2);
        byte[] byArray = new byte[n2];
        for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }

    @Override
    public int available() throws IOException {
        return this.impl.available();
    }

    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        } else {
            this.impl.close();
        }
        this.closing = false;
    }

    void setEOF(boolean bl) {
        this.eof = bl;
    }

    @Override
    protected void finalize() {
    }

    private static native void init();

    static {
        SocketInputStream.init();
    }
}

